/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.base;

import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.progress.BusyIndicator;

public class AddDataHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(AddDataHandler.class);
    private static final long serialVersionUID = 1L;
    BagView bagView;

    public AddDataHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void execute() {
        BagView.statusBarEnd();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BusyIndicator.showAt((Component)Application.instance().getActiveWindow().getControl());
        this.addData();
        BusyIndicator.clearAt((Component)Application.instance().getActiveWindow().getControl());
    }

    void addData() {
        File selectFile = new File(File.separator + ".");
        JFrame frame = new JFrame();
        JFileChooser fc = new JFileChooser(selectFile);
        fc.setDialogType(0);
        fc.setMultiSelectionEnabled(true);
        fc.setFileSelectionMode(2);
        fc.setDialogTitle("Add File or Directory");
        int option = fc.showOpenDialog(frame);
        if (option == 0) {
            File[] files = fc.getSelectedFiles();
            String message = ApplicationContextUtil.getMessage("bag.message.filesadded");
            if (files != null && files.length > 0) {
                this.addBagData(files);
                ApplicationContextUtil.addConsoleMessage(message + " " + AddDataHandler.getFileNames(files));
            } else {
                File file = fc.getSelectedFile();
                this.addBagData(file);
                ApplicationContextUtil.addConsoleMessage(message + " " + file.getAbsolutePath());
            }
            this.bagView.bagPayloadTreePanel.refresh(this.bagView.bagPayloadTree);
            this.bagView.updateAddData();
        }
    }

    private static String getFileNames(File[] files) {
        StringBuilder stringBuff = new StringBuilder();
        int totalFileCount = files.length;
        int displayCount = 20;
        if (totalFileCount < 20) {
            displayCount = totalFileCount;
        }
        for (int i = 0; i < displayCount; ++i) {
            if (i != 0) {
                stringBuff.append("\n");
            }
            stringBuff.append(files[i].getAbsolutePath());
        }
        if (totalFileCount > displayCount) {
            stringBuff.append("\n").append(totalFileCount - displayCount).append(" more...");
        }
        return stringBuff.toString();
    }

    private void addBagData(File[] files) {
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                log.info("addBagData[{}] {}", (Object)i, (Object)files[i].getName());
                this.addBagData(files[i]);
            }
        }
    }

    private void addBagData(File file) {
        BusyIndicator.showAt((Component)Application.instance().getActiveWindow().getControl());
        try {
            this.bagView.getBag().addFileToPayload(file);
            boolean alreadyExists = this.bagView.bagPayloadTree.addNodes(file, false);
            if (alreadyExists) {
                BagView.showWarningErrorDialog("Warning - file already exists", "File: " + file.getName() + "\nalready exists in bag.");
            }
        }
        catch (Exception e) {
            log.error("Failed to add bag file", (Throwable)e);
            BagView.showWarningErrorDialog("Error - file not added", "Error adding bag file: " + file + "\ndue to:\n" + e.getMessage());
        }
        BusyIndicator.clearAt((Component)Application.instance().getActiveWindow().getControl());
    }
}

