/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.base;

import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.verify.impl.CompleteVerifierImpl;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public class CompleteBagHandler
extends AbstractAction
implements Progress {
    private static final long serialVersionUID = 1L;
    private final BagView bagView;
    private String messages;

    public CompleteBagHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.completeBag();
    }

    void completeBag() {
        this.bagView.statusBarBegin(this, "Checking if complete...", null);
    }

    @Override
    public void execute() {
        DefaultBag bag = this.bagView.getBag();
        try {
            CompleteVerifierImpl completeVerifier = new CompleteVerifierImpl();
            completeVerifier.addProgressListener((ProgressListener)this.bagView.task);
            this.bagView.longRunningProcess = completeVerifier;
            this.messages = bag.completeBag(completeVerifier);
            if (this.messages != null && !this.messages.trim().isEmpty()) {
                BagView.showWarningErrorDialog("Warning - incomplete", "Is complete result: " + this.messages);
            } else {
                BagView.showWarningErrorDialog("Is Complete Dialog", "Bag is complete.");
            }
            SwingUtilities.invokeLater(() -> ApplicationContextUtil.addConsoleMessage(this.messages));
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.bagView.longRunningProcess.isCancelled()) {
                BagView.showWarningErrorDialog("Check cancelled", "Completion check cancelled.");
            } else {
                BagView.showWarningErrorDialog("Warning - complete check interrupted", "Error checking bag completeness: " + e.getMessage());
            }
        }
        finally {
            this.bagView.task.done();
            BagView.statusBarEnd();
        }
    }
}

