/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.base;

import cool.pandora.modeller.Profile;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.base.StartNewBagHandler;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.base.NewBagInPlaceFrame;
import gov.loc.repository.bagit.BagFactory;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBagInPlaceHandler
extends AbstractAction
implements Progress {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(StartNewBagHandler.class);
    private final BagView bagView;

    public CreateBagInPlaceHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createBagInPlace();
    }

    @Override
    public void execute() {
        BagView.statusBarEnd();
    }

    void createBagInPlace() {
        NewBagInPlaceFrame newBagInPlaceFrame = new NewBagInPlaceFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.newbaginplace"));
        newBagInPlaceFrame.setBag(this.bagView.getBag());
        newBagInPlaceFrame.setVisible(true);
    }

    public void createPreBag(File dataFile, String profileName) {
        if (dataFile != null && profileName != null) {
            log.info("Creating a new bag in place with data: {}, version: {}, profile: {}", new Object[]{dataFile.getName(), BagFactory.LATEST.versionString, profileName});
            this.bagView.clearBagHandler.clearExistingBag();
            try {
                this.bagView.getBag().createPreBag(dataFile);
            }
            catch (Exception e) {
                BagView.showWarningErrorDialog("Error - bagging in place", e.getMessage());
                return;
            }
            DefaultBag bag = this.bagView.getBag();
            String bagFileName = dataFile.getName();
            bag.setName(bagFileName);
            this.bagView.infoInputPane.setBagName(bagFileName);
            this.setProfile(profileName);
            this.bagView.saveBagHandler.save(dataFile);
        } else {
            log.warn("datafile is null? {} profileName is null? {}", (Object)(dataFile == null ? 1 : 0), (Object)(profileName == null ? 1 : 0));
        }
    }

    public void createPreBagAddKeepFilesToEmptyFolders(File dataFile, String profileName) {
        if (dataFile != null && profileName != null) {
            log.info("Creating a new bag in place with data: {}, version: {}, profile: {}", new Object[]{dataFile.getName(), BagFactory.LATEST.versionString, profileName});
            this.bagView.clearBagHandler.clearExistingBag();
            try {
                this.bagView.getBag().createPreBagAddKeepFilesToEmptyFolders(dataFile);
            }
            catch (Exception e) {
                BagView.showWarningErrorDialog("Error - bagging in place", "No file or directory selection was made!\n");
                return;
            }
            DefaultBag bag = this.bagView.getBag();
            String bagFileName = dataFile.getName();
            bag.setName(bagFileName);
            this.bagView.infoInputPane.setBagName(bagFileName);
            this.setProfile(profileName);
            this.bagView.saveBagHandler.save(dataFile);
        } else {
            log.warn("datafile is null? {} profileName is null? {}", (Object)(dataFile == null ? 1 : 0), (Object)(profileName == null ? 1 : 0));
        }
    }

    private void setProfile(String selected) {
        Profile profile = this.bagView.getProfileStore().getProfile(selected);
        log.info("bagProject: {}", (Object)profile.getName());
        DefaultBag bag = this.bagView.getBag();
        bag.setProfile(profile, true);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Profile Name", profile.getName());
        this.bagView.getBag().updateBagInfo(map);
    }
}

