/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.base;

import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class RemoveTagFileHandler
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    BagView bagView;

    public RemoveTagFileHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.removeTagFile();
    }

    private void removeTagFile() {
        DefaultBag bag = this.bagView.getBag();
        TreePath[] paths = this.bagView.bagTagFileTree.getSelectionPaths();
        if (paths != null) {
            DefaultTreeModel model = (DefaultTreeModel)this.bagView.bagTagFileTree.getModel();
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                try {
                    if (node == null) continue;
                    if (node instanceof MutableTreeNode) {
                        bag.removeBagFile(node.toString());
                        ApplicationContextUtil.addConsoleMessage("Tag file removed: " + node.toString());
                        model.removeNodeFromParent((MutableTreeNode)node);
                        continue;
                    }
                    bag.removeBagFile((String)node);
                    ApplicationContextUtil.addConsoleMessage("Tag file removed: " + node.toString());
                    DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(node);
                    model.removeNodeFromParent(aNode);
                }
                catch (Exception e) {
                    BagView.showWarningErrorDialog("Error - file not removed", "Error trying to remove file: " + node + "\n" + e.getMessage());
                }
            }
            this.bagView.bagTagFileTree.removeSelectionPaths(paths);
            this.bagView.bagTagFileTreePanel.refresh(this.bagView.bagTagFileTree);
        }
    }
}

