/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.base;

import cool.pandora.modeller.Profile;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.BagInfoInputPane;
import cool.pandora.modeller.ui.BagTree;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.base.NewBagFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartNewBagHandler
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(StartNewBagHandler.class);
    BagView bagView;

    public StartNewBagHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.newBag();
    }

    void newBag() {
        NewBagFrame newBagFrame = new NewBagFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.new"));
        newBagFrame.setVisible(true);
    }

    public void createNewBag(String profileName) {
        log.info("Creating a new bag with version: {}, profile: {}", (Object)BagFactory.LATEST.versionString, (Object)profileName);
        this.bagView.clearBagHandler.clearExistingBag();
        DefaultBag bag = this.bagView.getBag();
        this.bagView.infoInputPane.bagInfoInputPane.enableForms(true);
        String bagName = this.bagView.getPropertyMessage("bag.label.noname");
        bag.setName(bagName);
        this.bagView.infoInputPane.setBagName(bagName);
        this.bagView.bagTagFileTree = new BagTree(this.bagView, bag.getName());
        Collection tags = bag.getTags();
        for (BagFile bf : tags) {
            this.bagView.bagTagFileTree.addNode(bf.getFilepath());
        }
        this.bagView.bagTagFileTreePanel.refresh(this.bagView.bagTagFileTree);
        this.bagView.updateBaggerRules();
        bag.setRootDir(this.bagView.getBagRootPath());
        this.bagView.infoInputPane.bagInfoInputPane.populateForms(bag);
        ApplicationContextUtil.addConsoleMessage("A new bag has been created in memory.");
        this.bagView.updateNewBag();
        this.bagView.infoInputPane.bagVersionValue.setText(BagFactory.LATEST.versionString);
        this.changeProfile(profileName);
    }

    private void changeProfile(String selected) {
        Profile profile = this.bagView.getProfileStore().getProfile(selected);
        log.info("bagProject: {}", (Object)profile.getName());
        DefaultBag bag = this.bagView.getBag();
        bag.setProfile(profile, true);
        BagInfoInputPane.updateProject(this.bagView);
        this.bagView.infoInputPane.setProfile(bag.getProfile().getName());
    }
}

