/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.common;

import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.ui.handlers.common.TextObjectURI;
import cool.pandora.modeller.ui.util.URIResolver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IIIFObjectURI {
    protected static final Logger log = LoggerFactory.getLogger(TextObjectURI.class);

    private IIIFObjectURI() {
    }

    public static URI buildContainerURI(Map<String, BagInfoField> map, String containerKey) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey(containerKey).pathType(4).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getCollectionIdURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).pathType(2).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getObjektURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).pathType(3).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getManifestResource(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).pathType(6).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getSequenceContainerURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("IIIFSequenceContainer").pathType(4).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getSequenceObjectURI(Map<String, BagInfoField> map, String sequenceID) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("IIIFSequenceContainer").resource(sequenceID).pathType(5).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getCanvasContainerURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("IIIFCanvasContainer").pathType(4).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getCanvasObjectURI(Map<String, BagInfoField> map, String resourceID) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("IIIFCanvasContainer").resource(resourceID).pathType(5).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getListContainerURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("IIIFListContainer").pathType(4).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getListObjectURI(Map<String, BagInfoField> map, String resourceID) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("IIIFListContainer").resource(resourceID).pathType(5).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getResourceContainerURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("IIIFResourceContainer").pathType(4).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getDestinationURI(Map<String, BagInfoField> map, String filename) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("IIIFResourceContainer").resource(filename).pathType(5).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static String getListServiceBaseURI(Map<String, BagInfoField> map) {
        return URIResolver.ContainerURIResolverNormal.getMapValue(map, "ListServiceBaseURI");
    }
}

