/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.common;

import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.ui.util.URIResolver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextObjectURI {
    protected static final Logger log = LoggerFactory.getLogger(TextObjectURI.class);

    private TextObjectURI() {
    }

    public static String gethOCRResourceURI(Map<String, BagInfoField> map) {
        return URIResolver.ContainerURIResolverNormal.getMapValue(map, "TexthOCRResource");
    }

    public static URI getPageContainerURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("TextPageContainer").pathType(4).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getAreaContainerURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("TextAreaContainer").pathType(4).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getLineContainerURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("TextLineContainer").pathType(4).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getWordContainerURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("TextWordContainer").pathType(4).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getPageObjectURI(Map<String, BagInfoField> map, String resourceID) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("TextPageContainer").resource(resourceID).pathType(5).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getAreaObjectURI(Map<String, BagInfoField> map, String resourceID) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("TextAreaContainer").resource(resourceID).pathType(5).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getLineObjectURI(Map<String, BagInfoField> map, String resourceID) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("TextLineContainer").resource(resourceID).pathType(5).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static URI getWordObjectURI(Map<String, BagInfoField> map, String resourceID) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("TextWordContainer").resource(resourceID).pathType(5).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }
}

