/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.iiif;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.base.SaveBagHandler;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.handlers.iiif.ResourceIdentifierList;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.iiif.CreateCanvasesFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCanvasesHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(SaveBagHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public CreateCanvasesHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openCreateCanvasesFrame();
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.canvascreated");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        ResourceIdentifierList idList = new ResourceIdentifierList(this.bagView);
        ArrayList<String> resourceIDList = idList.getResourceIdentifierList();
        for (String resourceID : resourceIDList) {
            URI canvasObjectURI = IIIFObjectURI.getCanvasObjectURI(map, resourceID);
            try {
                ModellerClient.doPut((URI)canvasObjectURI);
                ApplicationContextUtil.addConsoleMessage(message + " " + canvasObjectURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openCreateCanvasesFrame() {
        DefaultBag bag = this.bagView.getBag();
        CreateCanvasesFrame createCanvasesFrame = new CreateCanvasesFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.canvas"));
        createCanvasesFrame.setBag(bag);
        createCanvasesFrame.setVisible(true);
    }
}

