/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.iiif;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.handlers.common.TextObjectURI;
import cool.pandora.modeller.ui.handlers.common.TextSequenceMetadata;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.iiif.PatchListFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import cool.pandora.modeller.util.ResourceList;
import cool.pandora.modeller.util.ResourceObjectNode;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jena.rdf.model.RDFNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchListHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(PatchListHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public PatchListHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.listpatched");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        URI resourceContainerURI = TextObjectURI.getWordContainerURI(map);
        URI listContainerURI = IIIFObjectURI.getListContainerURI(map);
        String listServiceBaseURI = bag.getListServiceBaseURI();
        ResourceList listList = new ResourceList(listContainerURI);
        ArrayList listsList = listList.getResourceList();
        ResourceList resourceList = new ResourceList(resourceContainerURI);
        ArrayList resourcesList = resourceList.getResourceList();
        String collectionPredicate = "http://iiif.io/api/presentation/2#hasAnnotations";
        Map<String, List<String>> pageResourcesMap = PatchListHandler.getPageResourcesMap(listsList, resourcesList);
        Map<String, String> resourceTargetMap = PatchListHandler.getResourceTargetMap(resourcesList);
        for (String listURI : listsList) {
            InputStream rdfBody = TextSequenceMetadata.getListSequenceMetadata(pageResourcesMap, listURI, resourceTargetMap, "http://iiif.io/api/presentation/2#hasAnnotations", listServiceBaseURI);
            URI destinationURI = URI.create(listURI);
            try {
                ModellerClient.doPatch((URI)destinationURI, (InputStream)rdfBody);
                ApplicationContextUtil.addConsoleMessage(message + " " + destinationURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    private static Map<String, String> getResourceTargetMap(List<String> resourcesList) {
        HashMap<String, String> wordTargetMap = new HashMap<String, String>();
        for (String resource : resourcesList) {
            RDFNode target = PatchListHandler.getResourceTarget(resource);
            if (target == null) continue;
            wordTargetMap.put(resource, target.toString());
        }
        return wordTargetMap;
    }

    private static Map<String, List<String>> getPageResourcesMap(ArrayList<String> listsList, ArrayList<String> resourcesList) {
        HashMap<String, List<String>> pageResourcesMap = new HashMap<String, List<String>>();
        for (String list : listsList) {
            ArrayList<String> rl = new ArrayList<String>();
            for (String resource : resourcesList) {
                String var2;
                String var1 = StringUtils.substringAfter((String)list, (String)"list/");
                if (!Objects.equals(var1, var2 = org.apache.commons.lang3.StringUtils.leftPad((String)StringUtils.substringBefore((String)StringUtils.substringAfter((String)resource, (String)"word/"), (String)"_"), (int)3, (String)"0"))) continue;
                rl.add(resource);
            }
            pageResourcesMap.put(list, rl);
        }
        return pageResourcesMap;
    }

    void openPatchListFrame() {
        DefaultBag bag = this.bagView.getBag();
        PatchListFrame patchListFrame = new PatchListFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.patch.list"));
        patchListFrame.setBag(bag);
        patchListFrame.setVisible(true);
    }

    private static RDFNode getResourceTarget(String resourceURI) {
        ResourceObjectNode resourceObjectNode = ResourceObjectNode.init().resourceURI(resourceURI).resourceProperty("http://www.w3.org/ns/oa#hasTarget").build();
        ArrayList resourceTarget = resourceObjectNode.render();
        if (resourceTarget.isEmpty()) {
            return null;
        }
        return (RDFNode)resourceTarget.get(0);
    }
}

