/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.iiif;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.BaggerFileEntity;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.iiif.UploadBagFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import cool.pandora.modeller.util.ImageIOUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadBagHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(UploadBagHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public UploadBagHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.fileuploaded");
        DefaultBag bag = this.bagView.getBag();
        List payload = bag.getPayloadPaths();
        HashMap map = bag.getInfo().getFieldMap();
        String basePath = "data";
        Path rootDir = this.bagView.getBagRootPath().toPath();
        for (String filePath : payload) {
            String filename = BaggerFileEntity.removeBasePath((String)"data", (String)filePath);
            URI destinationURI = IIIFObjectURI.getDestinationURI(map, filename);
            Path absoluteFilePath = rootDir.resolve(filePath);
            File resourceFile = absoluteFilePath.toFile();
            String contentType = ImageIOUtil.getImageMIMEType((File)resourceFile);
            try {
                ModellerClient.doBinaryPut((URI)destinationURI, (File)resourceFile, (String)contentType);
                ApplicationContextUtil.addConsoleMessage(message + " " + destinationURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openUploadBagFrame() {
        DefaultBag bag = this.bagView.getBag();
        UploadBagFrame uploadBagFrame = new UploadBagFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.upload"));
        uploadBagFrame.setBag(bag);
        uploadBagFrame.setVisible(true);
    }
}

