/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.text;

import cool.pandora.modeller.DocManifestBuilder;
import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.hOCRData;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.TextObjectURI;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.text.CreatePagesFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePagesHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(CreatePagesHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public CreatePagesHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openCreatePagesFrame();
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.pagecreated");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        String url = bag.gethOCRResource();
        List pageIdList = null;
        try {
            hOCRData hocr = DocManifestBuilder.gethOCRProjectionFromURL((String)url);
            pageIdList = DocManifestBuilder.getPageIdList((hOCRData)hocr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (pageIdList != null);
        for (String resourceID : pageIdList) {
            resourceID = StringUtils.substringAfter((String)resourceID, (String)"_");
            URI pageObjectURI = TextObjectURI.getPageObjectURI(map, resourceID);
            try {
                ModellerClient.doPut((URI)pageObjectURI);
                ApplicationContextUtil.addConsoleMessage(message + " " + pageObjectURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openCreatePagesFrame() {
        DefaultBag bag = this.bagView.getBag();
        CreatePagesFrame createPagesFrame = new CreatePagesFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.pages"));
        createPagesFrame.setBag(bag);
        createPagesFrame.setVisible(true);
    }
}

