/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.text;

import cool.pandora.modeller.CanvasRegionURI;
import cool.pandora.modeller.DocManifestBuilder;
import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.Region;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.hOCRData;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.handlers.common.NodeMap;
import cool.pandora.modeller.ui.handlers.common.TextObjectURI;
import cool.pandora.modeller.ui.handlers.common.TextSequenceMetadata;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.text.PatchAreasFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchAreasHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(PatchAreasHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public PatchAreasHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openPatchAreasFrame();
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.areapatched");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        URI canvasContainerURI = IIIFObjectURI.getCanvasContainerURI(map);
        URI lineContainerIRI = TextObjectURI.getLineContainerURI(map);
        String collectionPredicate = "http://iiif.io/api/text#hasLines";
        String url = bag.gethOCRResource();
        List pageIdList = null;
        Map<String, List<String>> lineIdmap = null;
        Map<String, String> bboxmap = null;
        try {
            hOCRData hocr = DocManifestBuilder.gethOCRProjectionFromURL((String)url);
            pageIdList = DocManifestBuilder.getPageIdList((hOCRData)hocr);
            List areaIdList = DocManifestBuilder.getAreaIdList((hOCRData)hocr);
            lineIdmap = NodeMap.getLineIdMap(hocr, areaIdList);
            bboxmap = NodeMap.getBBoxAreaMap(hocr, areaIdList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map<String, String> canvasPageMap = NodeMap.getCanvasPageMap(pageIdList, canvasContainerURI);
        Map<String, String> pageIdMap = NodeMap.getPageIdMap(pageIdList);
        assert (lineIdmap != null);
        ArrayList<String> areaKeyList = new ArrayList<String>(lineIdmap.keySet());
        for (String areaId : areaKeyList) {
            URI areaObjectURI = TextObjectURI.getAreaObjectURI(map, areaId);
            assert (canvasPageMap != null);
            String canvasURI = canvasPageMap.get(StringUtils.substringBefore((String)areaId, (String)"_"));
            assert (pageIdMap != null);
            String hOCRAreaId = "block_" + areaId;
            String bbox = bboxmap.get(hOCRAreaId);
            String region = Region.region().bbox(bbox).build();
            String canvasRegionURI = CanvasRegionURI.regionuri().region(region).canvasURI(canvasURI).build();
            InputStream rdfBody = TextSequenceMetadata.getTextSequenceMetadata(lineIdmap, areaId, canvasRegionURI, "http://iiif.io/api/text#hasLines", lineContainerIRI);
            try {
                ModellerClient.doPatch((URI)areaObjectURI, (InputStream)rdfBody);
                ApplicationContextUtil.addConsoleMessage(message + " " + areaObjectURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openPatchAreasFrame() {
        DefaultBag bag = this.bagView.getBag();
        PatchAreasFrame patchAreasFrame = new PatchAreasFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.patch.areas"));
        patchAreasFrame.setBag(bag);
        patchAreasFrame.setVisible(true);
    }
}

