/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.text;

import cool.pandora.modeller.CanvasRegionURI;
import cool.pandora.modeller.DocManifestBuilder;
import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.Region;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.hOCRData;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.handlers.common.NodeMap;
import cool.pandora.modeller.ui.handlers.common.TextObjectURI;
import cool.pandora.modeller.ui.handlers.common.TextSequenceMetadata;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.text.PatchLinesFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchLinesHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(PatchLinesHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public PatchLinesHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openPatchLinesFrame();
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.linepatched");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        URI canvasContainerURI = IIIFObjectURI.getCanvasContainerURI(map);
        URI wordContainerIRI = TextObjectURI.getWordContainerURI(map);
        String collectionPredicate = "http://iiif.io/api/text#hasWords";
        String url = bag.gethOCRResource();
        List pageIdList = null;
        Map<String, List<String>> wordIdMap = null;
        Map<String, String> bboxmap = null;
        try {
            hOCRData hocr = DocManifestBuilder.gethOCRProjectionFromURL((String)url);
            pageIdList = DocManifestBuilder.getPageIdList((hOCRData)hocr);
            List lineIdList = DocManifestBuilder.getLineIdList((hOCRData)hocr);
            wordIdMap = NodeMap.getWordIdMap(hocr, lineIdList);
            bboxmap = NodeMap.getBBoxLineMap(hocr, lineIdList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map<String, String> canvasPageMap = NodeMap.getCanvasPageMap(pageIdList, canvasContainerURI);
        Map<String, String> pageIdMap = NodeMap.getPageIdMap(pageIdList);
        assert (wordIdMap != null);
        ArrayList<String> lineKeyList = new ArrayList<String>(wordIdMap.keySet());
        for (String lineId : lineKeyList) {
            URI lineObjectURI = TextObjectURI.getLineObjectURI(map, lineId);
            assert (canvasPageMap != null);
            String canvasURI = canvasPageMap.get(StringUtils.substringBefore((String)lineId, (String)"_"));
            assert (pageIdMap != null);
            String hOCRAreaId = "line_" + lineId;
            String bbox = bboxmap.get(hOCRAreaId);
            String region = Region.region().bbox(bbox).build();
            String canvasRegionURI = CanvasRegionURI.regionuri().region(region).canvasURI(canvasURI).build();
            InputStream rdfBody = TextSequenceMetadata.getTextSequenceMetadata(wordIdMap, lineId, canvasRegionURI, "http://iiif.io/api/text#hasWords", wordContainerIRI);
            try {
                ModellerClient.doPatch((URI)lineObjectURI, (InputStream)rdfBody);
                ApplicationContextUtil.addConsoleMessage(message + " " + lineObjectURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openPatchLinesFrame() {
        DefaultBag bag = this.bagView.getBag();
        PatchLinesFrame patchLinesFrame = new PatchLinesFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.patch.lines"));
        patchLinesFrame.setBag(bag);
        patchLinesFrame.setVisible(true);
    }
}

