/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.text;

import cool.pandora.modeller.CanvasRegionURI;
import cool.pandora.modeller.DocManifestBuilder;
import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.Region;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.hOCRData;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.handlers.common.NodeMap;
import cool.pandora.modeller.ui.handlers.common.TextObjectURI;
import cool.pandora.modeller.ui.handlers.common.TextSequenceMetadata;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.text.PatchPagesFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchPagesHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(PatchPagesHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public PatchPagesHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openPatchPagesFrame();
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.pagepatched");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        URI canvasContainerURI = IIIFObjectURI.getCanvasContainerURI(map);
        URI areaContainerIRI = TextObjectURI.getAreaContainerURI(map);
        String collectionPredicate = "http://iiif.io/api/text#hasAreas";
        String url = bag.gethOCRResource();
        List pageIdList = null;
        Map<String, List<String>> areaIdmap = null;
        Map<String, String> bboxmap = null;
        try {
            hOCRData hocr = DocManifestBuilder.gethOCRProjectionFromURL((String)url);
            pageIdList = DocManifestBuilder.getPageIdList((hOCRData)hocr);
            areaIdmap = NodeMap.getAreaIdMap(hocr, pageIdList);
            bboxmap = NodeMap.getBBoxMap(hocr, pageIdList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map<String, String> canvasPageMap = NodeMap.getCanvasPageMap(pageIdList, canvasContainerURI);
        Map<String, String> pageIdMap = NodeMap.getPageIdMap(pageIdList);
        assert (areaIdmap != null);
        ArrayList<String> pageKeyList = new ArrayList<String>(areaIdmap.keySet());
        for (String pageId : pageKeyList) {
            URI pageObjectURI = TextObjectURI.getPageObjectURI(map, pageId);
            assert (canvasPageMap != null);
            String canvasURI = canvasPageMap.get(pageId);
            assert (pageIdMap != null);
            String hOCRPageId = pageIdMap.get(pageId);
            String bbox = bboxmap.get(hOCRPageId);
            String region = Region.region().bbox(bbox).build();
            String canvasRegionURI = CanvasRegionURI.regionuri().region(region).canvasURI(canvasURI).build();
            InputStream rdfBody = TextSequenceMetadata.getTextSequenceMetadata(areaIdmap, pageId, canvasRegionURI, "http://iiif.io/api/text#hasAreas", areaContainerIRI);
            try {
                ModellerClient.doPatch((URI)pageObjectURI, (InputStream)rdfBody);
                ApplicationContextUtil.addConsoleMessage(message + " " + pageObjectURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openPatchPagesFrame() {
        DefaultBag bag = this.bagView.getBag();
        PatchPagesFrame patchPagesFrame = new PatchPagesFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.patch.pages"));
        patchPagesFrame.setBag(bag);
        patchPagesFrame.setVisible(true);
    }
}

