/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.jpanel.base;

import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import cool.pandora.modeller.ui.util.LayoutUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationPage;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.TitlePane;
import org.springframework.richclient.util.GuiStandardUtils;

public class NewBagInPlaceFrame
extends JFrame
implements ActionListener {
    protected static final Logger log = LoggerFactory.getLogger(NewBagInPlaceFrame.class);
    private static final long serialVersionUID = 1L;
    private final transient BagView bagView;
    private transient DefaultBag bag = null;
    private final JPanel createPanel;
    private JTextField bagNameField;
    private File bagFile;
    private JComboBox<String> profileList;
    protected static final String DEFAULT_FINISH_COMMAND_ID = "okCommand";
    protected static final String DEFAULT_CANCEL_COMMAND_ID = "cancelCommand";
    private transient ActionCommand finishCommand;
    private transient ActionCommand cancelCommand;

    public NewBagInPlaceFrame(BagView bagView, String title) {
        super(title);
        Application app = Application.instance();
        ApplicationPage page = app.getActiveWindow().getPage();
        PageComponent component = page.getActiveComponent();
        this.bagView = component != null ? ApplicationContextUtil.getBagView() : bagView;
        if (bagView != null) {
            this.bag = bagView.getBag();
            this.getContentPane().removeAll();
            this.createPanel = this.createComponents();
        } else {
            this.createPanel = new JPanel();
        }
        this.getContentPane().add((Component)this.createPanel, "Center");
        Dimension preferredDimension = new Dimension(400, 230);
        this.setPreferredSize(preferredDimension);
        this.setLocation(200, 100);
        this.pack();
    }

    private JPanel createComponents() {
        TitlePane titlePane = new TitlePane();
        this.initStandardCommands();
        JPanel pageControl = new JPanel(new BorderLayout());
        JPanel titlePaneContainer = new JPanel(new BorderLayout());
        titlePane.setTitle(this.bagView.getPropertyMessage("NewBagInPlace.title"));
        titlePane.setMessage((Message)new DefaultMessage(this.bagView.getPropertyMessage("NewBagInPlace.description")));
        titlePaneContainer.add(titlePane.getControl());
        titlePaneContainer.add((Component)new JSeparator(), "South");
        pageControl.add((Component)titlePaneContainer, "North");
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        this.layoutSelectDataContent(contentPanel, row++);
        this.layoutProfileSelectionContent(contentPanel, row++);
        this.layoutAddKeepFilesToEmptyCheckBox(contentPanel, row++);
        NewBagInPlaceFrame.layoutSpacer(contentPanel, row++);
        GuiStandardUtils.attachDialogBorder((JComponent)contentPanel);
        pageControl.add(contentPanel);
        JComponent buttonBar = this.createButtonBar();
        pageControl.add((Component)buttonBar, "South");
        this.pack();
        return pageControl;
    }

    private void layoutSelectDataContent(JPanel contentPanel, int row) {
        GridBagConstraints glbc = new GridBagConstraints();
        JLabel location = new JLabel("Select Data:");
        JButton saveAsButton = new JButton(this.bagView.getPropertyMessage("bag.button.browse"));
        saveAsButton.addActionListener(new BrowseFileHandler());
        saveAsButton.setEnabled(true);
        saveAsButton.setToolTipText(this.bagView.getPropertyMessage("bag.button.browse.help"));
        String fileName = "";
        if (this.bag != null) {
            fileName = this.bag.getName();
        }
        this.bagNameField = new JTextField(fileName);
        this.bagNameField.setCaretPosition(fileName.length());
        this.bagNameField.setEditable(false);
        this.bagNameField.setEnabled(false);
        glbc = LayoutUtil.buildGridBagConstraints(0, row, 1, 1, 1, 50, 0, 17);
        contentPanel.add((Component)location, glbc);
        glbc = LayoutUtil.buildGridBagConstraints(2, row, 1, 1, 1, 50, 0, 13);
        contentPanel.add((Component)saveAsButton, glbc);
        glbc = LayoutUtil.buildGridBagConstraints(1, row, 1, 1, 80, 50, 2, 17);
        glbc.ipadx = 0;
        contentPanel.add((Component)this.bagNameField, glbc);
    }

    private void layoutProfileSelectionContent(JPanel contentPane, int row) {
        JLabel bagProfileLabel = new JLabel(this.bagView.getPropertyMessage("Select Profile:"));
        bagProfileLabel.setToolTipText(this.bagView.getPropertyMessage("bag.projectlist.help"));
        this.profileList = new JComboBox<String>(this.bagView.getProfileStore().getProfileNames());
        this.profileList.setName(this.bagView.getPropertyMessage("bag.label.projectlist"));
        this.profileList.setSelectedItem(this.bagView.getPropertyMessage("bag.project.noproject"));
        this.profileList.setToolTipText(this.bagView.getPropertyMessage("bag.projectlist.help"));
        GridBagConstraints glbc = new GridBagConstraints();
        JLabel spacerLabel = new JLabel();
        glbc = LayoutUtil.buildGridBagConstraints(0, row, 1, 1, 5, 50, 2, 17);
        contentPane.add((Component)bagProfileLabel, glbc);
        glbc = LayoutUtil.buildGridBagConstraints(1, row, 1, 1, 40, 50, 2, 10);
        contentPane.add(this.profileList, glbc);
        glbc = LayoutUtil.buildGridBagConstraints(2, row, 1, 1, 40, 50, 0, 13);
        contentPane.add((Component)spacerLabel, glbc);
    }

    private void layoutAddKeepFilesToEmptyCheckBox(JPanel contentPane, int row) {
        JLabel addKeepFilesToEmptyFoldersCheckBoxLabel = new JLabel(this.bagView.getPropertyMessage("bag.label.addkeepfilestoemptyfolders"));
        addKeepFilesToEmptyFoldersCheckBoxLabel.setToolTipText(this.bagView.getPropertyMessage("bag.addkeepfilestoemptyfolders.help"));
        JCheckBox addKeepFilesToEmptyFoldersCheckBox = new JCheckBox(this.bagView.getPropertyMessage(""));
        addKeepFilesToEmptyFoldersCheckBox.setSelected(this.bag.isAddKeepFilesToEmptyFolders());
        addKeepFilesToEmptyFoldersCheckBox.addActionListener(new AddKeepFilesToEmptyFoldersHandler());
        GridBagConstraints glbc = new GridBagConstraints();
        JLabel spacerLabel = new JLabel();
        glbc = LayoutUtil.buildGridBagConstraints(0, row, 1, 1, 5, 50, 2, 17);
        contentPane.add((Component)addKeepFilesToEmptyFoldersCheckBoxLabel, glbc);
        glbc = LayoutUtil.buildGridBagConstraints(1, row, 1, 1, 40, 50, 2, 10);
        contentPane.add((Component)addKeepFilesToEmptyFoldersCheckBox, glbc);
        glbc = LayoutUtil.buildGridBagConstraints(2, row, 1, 1, 40, 50, 0, 13);
        contentPane.add((Component)spacerLabel, glbc);
    }

    private static void layoutSpacer(JPanel contentPanel, int row) {
        GridBagConstraints glbc = new GridBagConstraints();
        glbc = LayoutUtil.buildGridBagConstraints(0, row, 1, 1, 1, 50, 0, 17);
        JLabel spacerLabel = new JLabel("");
        contentPanel.add((Component)spacerLabel, glbc);
    }

    protected JComponent createButtonBar() {
        CommandGroup dialogCommandGroup = CommandGroup.createCommandGroup(null, (Object[])this.getCommandGroupMembers());
        JComponent buttonBar = dialogCommandGroup.createButtonBar();
        GuiStandardUtils.attachDialogBorder((JComponent)buttonBar);
        return buttonBar;
    }

    protected Object[] getCommandGroupMembers() {
        return new AbstractCommand[]{this.finishCommand, this.cancelCommand};
    }

    private void initStandardCommands() {
        this.finishCommand = new ActionCommand(NewBagInPlaceFrame.getFinishCommandId()){

            public void doExecuteCommand() {
                new OkNewBagHandler().actionPerformed(null);
            }
        };
        this.cancelCommand = new ActionCommand(NewBagInPlaceFrame.getCancelCommandId()){

            public void doExecuteCommand() {
                new CancelNewBagHandler().actionPerformed(null);
            }
        };
    }

    protected static String getFinishCommandId() {
        return DEFAULT_FINISH_COMMAND_ID;
    }

    protected static String getCancelCommandId() {
        return DEFAULT_CANCEL_COMMAND_ID;
    }

    public void setBag(DefaultBag bag) {
        this.bag = bag;
        this.createPanel.invalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.invalidate();
        this.repaint();
    }

    private class CancelNewBagHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelNewBagHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewBagInPlaceFrame.this.setVisible(false);
        }
    }

    private class OkNewBagHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OkNewBagHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.info("BagVersionFrame.OkNewBagHandler");
            NewBagInPlaceFrame.this.setVisible(false);
            if (NewBagInPlaceFrame.this.bagView.getBag().isAddKeepFilesToEmptyFolders()) {
                ((NewBagInPlaceFrame)NewBagInPlaceFrame.this).bagView.createBagInPlaceHandler.createPreBagAddKeepFilesToEmptyFolders(NewBagInPlaceFrame.this.bagFile, (String)NewBagInPlaceFrame.this.profileList.getSelectedItem());
            } else {
                ((NewBagInPlaceFrame)NewBagInPlaceFrame.this).bagView.createBagInPlaceHandler.createPreBag(NewBagInPlaceFrame.this.bagFile, (String)NewBagInPlaceFrame.this.profileList.getSelectedItem());
            }
        }
    }

    private class BrowseFileHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private BrowseFileHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int option;
            NewBagInPlaceFrame.this.bag = NewBagInPlaceFrame.this.bagView.getBag();
            File selectFile = new File(File.separator + ".");
            JFrame frame = new JFrame();
            JFileChooser fs = new JFileChooser(selectFile);
            fs.setDialogType(0);
            fs.setFileSelectionMode(1);
            fs.setDialogTitle("Existing Data Location");
            if (NewBagInPlaceFrame.this.bagView.getBagRootPath() != null) {
                fs.setCurrentDirectory(NewBagInPlaceFrame.this.bagView.getBagRootPath().getParentFile());
            }
            fs.setCurrentDirectory(NewBagInPlaceFrame.this.bag.getRootDir());
            if (NewBagInPlaceFrame.this.bag.getName() != null && !NewBagInPlaceFrame.this.bag.getName().equalsIgnoreCase(NewBagInPlaceFrame.this.bagView.getPropertyMessage("bag.label.noname"))) {
                String selectedName = NewBagInPlaceFrame.this.bag.getName();
                if (NewBagInPlaceFrame.this.bag.getSerialMode() == 1) {
                    selectedName = selectedName + ".zip";
                }
                fs.setSelectedFile(new File(selectedName));
            }
            if ((option = fs.showOpenDialog(frame)) == 0) {
                NewBagInPlaceFrame.this.bagFile = fs.getSelectedFile();
                String bagFileName = NewBagInPlaceFrame.this.bagFile.getAbsolutePath();
                NewBagInPlaceFrame.this.bagNameField.setText(bagFileName);
                NewBagInPlaceFrame.this.bagNameField.setCaretPosition(bagFileName.length());
                NewBagInPlaceFrame.this.bagNameField.invalidate();
            }
        }
    }

    private class AddKeepFilesToEmptyFoldersHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private AddKeepFilesToEmptyFoldersHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox cb = (JCheckBox)e.getSource();
            boolean isSelected = cb.isSelected();
            if (isSelected) {
                NewBagInPlaceFrame.this.bagView.getBag().isAddKeepFilesToEmptyFolders(true);
                ((NewBagInPlaceFrame)NewBagInPlaceFrame.this).bagView.infoInputPane.serializeValue.setText("true");
            } else {
                NewBagInPlaceFrame.this.bagView.getBag().isAddKeepFilesToEmptyFolders(false);
            }
        }
    }
}

