/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.jpanel.base;

import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class NewItemFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField itemName;
    JPanel itemPanel;
    private final JComboBox<String> itemList;

    public NewItemFrame(BagView bagView, JComboBox<String> itemList, String title) {
        super(title);
        this.itemList = itemList;
        DefaultBag bag = bagView.getBag();
        this.getContentPane().removeAll();
        JPanel addPanel = this.createComponents();
        Dimension preferredDimension = new Dimension(550, 200);
        addPanel.setPreferredSize(preferredDimension);
        this.getContentPane().add((Component)addPanel, "Center");
        this.pack();
    }

    private JPanel createComponents() {
        JLabel itemLabel = new JLabel("Add Item");
        this.itemName = new JTextField(10);
        this.itemName.setEnabled(true);
        GridBagLayout gridLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        NewItemFrame.buildConstraints(gbc, 0, 0, 1, 1, 20, 50, 0, 17);
        gridLayout.setConstraints(itemLabel, gbc);
        NewItemFrame.buildConstraints(gbc, 1, 0, 1, 1, 80, 50, 2, 10);
        gridLayout.setConstraints(this.itemName, gbc);
        JPanel itemPanel = new JPanel(gridLayout);
        itemPanel.add(itemLabel);
        itemPanel.add(this.itemName);
        JButton okButton = new JButton("Add");
        okButton.addActionListener(new OkAddFieldHandler());
        okButton.setEnabled(true);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new CancelAddFieldHandler());
        cancelButton.setEnabled(true);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints glbc = new GridBagConstraints();
        int row = 0;
        NewItemFrame.buildConstraints(glbc, 0, row, 2, 1, 100, 50, 2, 10);
        layout.setConstraints(itemPanel, glbc);
        NewItemFrame.buildConstraints(glbc, 0, ++row, 1, 1, 20, 50, 0, 17);
        layout.setConstraints(cancelButton, glbc);
        NewItemFrame.buildConstraints(glbc, 1, row, 1, 1, 80, 50, 0, 10);
        layout.setConstraints(okButton, glbc);
        JPanel panel = new JPanel(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add(itemPanel);
        panel.add(cancelButton);
        panel.add(okButton);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.invalidate();
        this.repaint();
    }

    private static void buildConstraints(GridBagConstraints gbc, int x, int y, int w, int h, int wx, int wy, int fill, int anchor) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.fill = fill;
        gbc.anchor = anchor;
    }

    private class CancelAddFieldHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelAddFieldHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewItemFrame.this.setVisible(false);
        }
    }

    private class OkAddFieldHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OkAddFieldHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = NewItemFrame.this.itemName.getText().trim();
            boolean b = false;
            for (int i = 0; i < NewItemFrame.this.itemList.getItemCount(); ++i) {
                String s = (String)NewItemFrame.this.itemList.getItemAt(i);
                if (s == null || !name.equalsIgnoreCase(s.trim())) continue;
                b = true;
                break;
            }
            NewItemFrame.this.setVisible(false);
            if (b) {
                BagView.showWarningErrorDialog("New Item Dialog", "Item already exists!");
                return;
            }
            NewItemFrame.this.itemList.addItem(name);
            NewItemFrame.this.itemList.invalidate();
            NewItemFrame.this.itemList.setSelectedItem(name);
        }
    }
}

