/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.jpanel.base;

import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import gov.loc.repository.bagit.Manifest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.TitlePane;
import org.springframework.richclient.util.GuiStandardUtils;

public class SaveBagFrame
extends JFrame
implements ActionListener {
    protected static final Logger log = LoggerFactory.getLogger(SaveBagFrame.class);
    private static final long serialVersionUID = 1L;
    private final transient BagView bagView;
    private File bagFile;
    private String bagFileName = "";
    private final JPanel savePanel;
    private JTextField bagNameField;
    private JLabel urlLabel;
    private JTextField urlField;
    JButton okButton;
    JButton cancelButton;
    private JRadioButton noneButton;
    private JRadioButton zipButton;
    JRadioButton tarButton;
    JRadioButton tarGzButton;
    JRadioButton tarBz2Button;
    protected static final String DEFAULT_FINISH_COMMAND_ID = "okCommand";
    protected static final String DEFAULT_CANCEL_COMMAND_ID = "cancelCommand";
    private transient ActionCommand finishCommand;
    private transient ActionCommand cancelCommand;

    public SaveBagFrame(BagView bagView, String title) {
        super(title);
        this.bagView = bagView;
        if (bagView != null) {
            this.getContentPane().removeAll();
            this.savePanel = this.createComponents();
        } else {
            this.savePanel = new JPanel();
        }
        this.getContentPane().add((Component)this.savePanel, "Center");
        Dimension preferredDimension = new Dimension(600, 400);
        this.setPreferredSize(preferredDimension);
        this.setBounds(300, 200, 600, 400);
        this.pack();
    }

    protected JComponent createButtonBar() {
        CommandGroup dialogCommandGroup = CommandGroup.createCommandGroup(null, (Object[])this.getCommandGroupMembers());
        JComponent buttonBar = dialogCommandGroup.createButtonBar();
        GuiStandardUtils.attachDialogBorder((JComponent)buttonBar);
        return buttonBar;
    }

    protected Object[] getCommandGroupMembers() {
        return new AbstractCommand[]{this.finishCommand, this.cancelCommand};
    }

    private void initStandardCommands() {
        this.finishCommand = new ActionCommand(SaveBagFrame.getFinishCommandId()){

            public void doExecuteCommand() {
                new OkSaveBagHandler().actionPerformed(null);
            }
        };
        this.cancelCommand = new ActionCommand(SaveBagFrame.getCancelCommandId()){

            public void doExecuteCommand() {
                new CancelSaveBagHandler().actionPerformed(null);
            }
        };
    }

    protected static String getFinishCommandId() {
        return DEFAULT_FINISH_COMMAND_ID;
    }

    protected static String getCancelCommandId() {
        return DEFAULT_CANCEL_COMMAND_ID;
    }

    private JPanel createComponents() {
        EmptyBorder border = new EmptyBorder(5, 5, 5, 5);
        TitlePane titlePane = new TitlePane();
        this.initStandardCommands();
        JPanel pageControl = new JPanel(new BorderLayout());
        JPanel titlePaneContainer = new JPanel(new BorderLayout());
        titlePane.setTitle(this.bagView.getPropertyMessage("SaveBagFrame.title"));
        titlePane.setMessage((Message)new DefaultMessage(this.bagView.getPropertyMessage("Define the Bag settings")));
        titlePaneContainer.add(titlePane.getControl());
        titlePaneContainer.add((Component)new JSeparator(), "South");
        pageControl.add((Component)titlePaneContainer, "North");
        JPanel contentPane = new JPanel();
        JLabel location = new JLabel("Save in:");
        JButton browseButton = new JButton(this.getMessage("bag.button.browse"));
        browseButton.addActionListener(new SaveBagAsHandler());
        browseButton.setEnabled(true);
        browseButton.setToolTipText(this.getMessage("bag.button.browse.help"));
        DefaultBag bag = this.bagView.getBag();
        if (bag != null) {
            this.bagNameField = new JTextField(bag.getName());
            this.bagNameField.setCaretPosition(bag.getName().length());
            this.bagNameField.setEditable(false);
            this.bagNameField.setEnabled(false);
        }
        JLabel holeyLabel = new JLabel(this.bagView.getPropertyMessage("bag.label.isholey"));
        holeyLabel.setToolTipText(this.bagView.getPropertyMessage("bag.isholey.help"));
        JCheckBox holeyCheckbox = new JCheckBox(this.bagView.getPropertyMessage("bag.checkbox.isholey"));
        holeyCheckbox.setBorder(border);
        holeyCheckbox.addActionListener(new HoleyBagHandler());
        holeyCheckbox.setToolTipText(this.bagView.getPropertyMessage("bag.isholey.help"));
        this.urlLabel = new JLabel(this.bagView.getPropertyMessage("baseURL.label"));
        this.urlLabel.setToolTipText(this.bagView.getPropertyMessage("baseURL.description"));
        this.urlField = new JTextField("");
        try {
            assert (bag != null);
            this.urlField.setText(bag.getFetch().getBaseURL());
        }
        catch (Exception e) {
            log.error("Failed to set url label", (Throwable)e);
        }
        this.urlField.setEnabled(false);
        JLabel serializeLabel = new JLabel(this.getMessage("bag.label.ispackage"));
        serializeLabel.setToolTipText(this.getMessage("bag.serializetype.help"));
        this.noneButton = new JRadioButton(this.getMessage("bag.serializetype.none"));
        this.noneButton.setEnabled(true);
        SerializeBagHandler serializeListener = new SerializeBagHandler();
        this.noneButton.addActionListener(serializeListener);
        this.noneButton.setToolTipText(this.getMessage("bag.serializetype.none.help"));
        this.zipButton = new JRadioButton(this.getMessage("bag.serializetype.zip"));
        this.zipButton.setEnabled(true);
        this.zipButton.addActionListener(serializeListener);
        this.zipButton.setToolTipText(this.getMessage("bag.serializetype.zip.help"));
        int mode = 2;
        if (bag != null) {
            mode = bag.getSerialMode();
        }
        if (mode == 0) {
            this.noneButton.setEnabled(true);
        } else if (mode == 1) {
            this.zipButton.setEnabled(true);
        } else {
            this.noneButton.setEnabled(true);
        }
        ButtonGroup serializeGroup = new ButtonGroup();
        serializeGroup.add(this.noneButton);
        serializeGroup.add(this.zipButton);
        JPanel serializeGroupPanel = new JPanel(new FlowLayout());
        serializeGroupPanel.add(serializeLabel);
        serializeGroupPanel.add(this.noneButton);
        serializeGroupPanel.add(this.zipButton);
        serializeGroupPanel.setBorder(border);
        serializeGroupPanel.setEnabled(true);
        serializeGroupPanel.setToolTipText(this.bagView.getPropertyMessage("bag.serializetype.help"));
        JLabel tagLabel = new JLabel(this.getMessage("bag.label.istag"));
        tagLabel.setToolTipText(this.getMessage("bag.label.istag.help"));
        JCheckBox isTagCheckbox = new JCheckBox();
        isTagCheckbox.setBorder(border);
        isTagCheckbox.addActionListener(new TagManifestHandler());
        isTagCheckbox.setToolTipText(this.getMessage("bag.checkbox.istag.help"));
        JLabel tagAlgorithmLabel = new JLabel(this.getMessage("bag.label.tagalgorithm"));
        tagAlgorithmLabel.setToolTipText(this.getMessage("bag.label.tagalgorithm.help"));
        ArrayList<String> listModel = new ArrayList<String>();
        for (Manifest.Algorithm algorithm : Manifest.Algorithm.values()) {
            listModel.add(algorithm.bagItAlgorithm);
        }
        JComboBox<String> tagAlgorithmList = new JComboBox<String>(listModel.toArray(new String[listModel.size()]));
        tagAlgorithmList.setName(this.getMessage("bag.tagalgorithmlist"));
        tagAlgorithmList.addActionListener(new TagAlgorithmListHandler());
        tagAlgorithmList.setToolTipText(this.getMessage("bag.tagalgorithmlist.help"));
        JLabel payloadLabel = new JLabel(this.getMessage("bag.label.ispayload"));
        payloadLabel.setToolTipText(this.getMessage("bag.ispayload.help"));
        JCheckBox isPayloadCheckbox = new JCheckBox();
        isPayloadCheckbox.setBorder(border);
        isPayloadCheckbox.addActionListener(new PayloadManifestHandler());
        isPayloadCheckbox.setToolTipText(this.getMessage("bag.ispayload.help"));
        JLabel payAlgorithmLabel = new JLabel(this.bagView.getPropertyMessage("bag.label.payalgorithm"));
        payAlgorithmLabel.setToolTipText(this.getMessage("bag.payalgorithm.help"));
        JComboBox<String> payAlgorithmList = new JComboBox<String>(listModel.toArray(new String[listModel.size()]));
        payAlgorithmList.setName(this.getMessage("bag.payalgorithmlist"));
        payAlgorithmList.addActionListener(new PayAlgorithmListHandler());
        payAlgorithmList.setToolTipText(this.getMessage("bag.payalgorithmlist.help"));
        if (bag != null) {
            String fileName = bag.getName();
            this.bagNameField = new JTextField(fileName);
            this.bagNameField.setCaretPosition(fileName.length());
            holeyCheckbox.setSelected(bag.isHoley());
            this.urlLabel.setEnabled(bag.isHoley());
            isTagCheckbox.setSelected(bag.isBuildTagManifest());
            tagAlgorithmList.setSelectedItem(bag.getTagManifestAlgorithm());
            isPayloadCheckbox.setSelected(bag.isBuildPayloadManifest());
            payAlgorithmList.setSelectedItem(bag.getPayloadManifestAlgorithm());
        }
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints glbc = new GridBagConstraints();
        JPanel panel = new JPanel(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        SaveBagFrame.buildConstraints(glbc, 0, row, 1, 1, 1, 50, 0, 17);
        layout.setConstraints(location, glbc);
        panel.add(location);
        SaveBagFrame.buildConstraints(glbc, 2, row, 1, 1, 1, 50, 0, 13);
        glbc.ipadx = 5;
        layout.setConstraints(browseButton, glbc);
        glbc.ipadx = 0;
        panel.add(browseButton);
        SaveBagFrame.buildConstraints(glbc, 1, row, 1, 1, 80, 50, 2, 17);
        glbc.ipadx = 5;
        layout.setConstraints(this.bagNameField, glbc);
        glbc.ipadx = 0;
        panel.add(this.bagNameField);
        SaveBagFrame.buildConstraints(glbc, 0, ++row, 1, 1, 1, 50, 0, 17);
        layout.setConstraints(holeyLabel, glbc);
        panel.add(holeyLabel);
        SaveBagFrame.buildConstraints(glbc, 1, row, 1, 1, 80, 50, 17, 17);
        layout.setConstraints(holeyCheckbox, glbc);
        panel.add(holeyCheckbox);
        SaveBagFrame.buildConstraints(glbc, 0, ++row, 1, 1, 1, 50, 0, 17);
        layout.setConstraints(this.urlLabel, glbc);
        panel.add(this.urlLabel);
        SaveBagFrame.buildConstraints(glbc, 1, row, 1, 1, 80, 50, 2, 10);
        layout.setConstraints(this.urlField, glbc);
        panel.add(this.urlField);
        SaveBagFrame.buildConstraints(glbc, 0, ++row, 1, 1, 1, 50, 0, 17);
        layout.setConstraints(serializeLabel, glbc);
        panel.add(serializeLabel);
        SaveBagFrame.buildConstraints(glbc, 1, row, 2, 1, 80, 50, 2, 17);
        layout.setConstraints(serializeGroupPanel, glbc);
        panel.add(serializeGroupPanel);
        SaveBagFrame.buildConstraints(glbc, 0, ++row, 1, 1, 1, 50, 0, 17);
        layout.setConstraints(tagLabel, glbc);
        panel.add(tagLabel);
        SaveBagFrame.buildConstraints(glbc, 1, row, 2, 1, 80, 50, 2, 10);
        layout.setConstraints(isTagCheckbox, glbc);
        panel.add(isTagCheckbox);
        SaveBagFrame.buildConstraints(glbc, 0, ++row, 1, 1, 1, 50, 0, 17);
        layout.setConstraints(tagAlgorithmLabel, glbc);
        panel.add(tagAlgorithmLabel);
        SaveBagFrame.buildConstraints(glbc, 1, row, 2, 1, 80, 50, 2, 10);
        layout.setConstraints(tagAlgorithmList, glbc);
        panel.add(tagAlgorithmList);
        SaveBagFrame.buildConstraints(glbc, 0, ++row, 1, 1, 1, 50, 0, 17);
        layout.setConstraints(payloadLabel, glbc);
        panel.add(payloadLabel);
        SaveBagFrame.buildConstraints(glbc, 1, row, 2, 1, 80, 50, 2, 10);
        layout.setConstraints(isPayloadCheckbox, glbc);
        panel.add(isPayloadCheckbox);
        SaveBagFrame.buildConstraints(glbc, 0, ++row, 1, 1, 1, 50, 0, 17);
        layout.setConstraints(payAlgorithmLabel, glbc);
        panel.add(payAlgorithmLabel);
        SaveBagFrame.buildConstraints(glbc, 1, row, 2, 1, 80, 50, 2, 10);
        layout.setConstraints(payAlgorithmList, glbc);
        panel.add(payAlgorithmList);
        SaveBagFrame.buildConstraints(glbc, 0, ++row, 1, 1, 1, 50, 0, 17);
        SaveBagFrame.buildConstraints(glbc, 1, row, 2, 1, 80, 50, 2, 10);
        GuiStandardUtils.attachDialogBorder((JComponent)contentPane);
        pageControl.add(panel);
        JComponent buttonBar = this.createButtonBar();
        pageControl.add((Component)buttonBar, "South");
        this.pack();
        return pageControl;
    }

    public void setBag(DefaultBag bag) {
        this.bagNameField.setText(bag.getName());
        short mode = bag.getSerialMode();
        if (mode == 0) {
            this.noneButton.setEnabled(true);
            this.noneButton.setSelected(true);
            this.bagView.infoInputPane.serializeValue.setText("none");
        } else if (mode == 1) {
            this.zipButton.setEnabled(true);
            this.zipButton.setSelected(true);
            this.bagView.infoInputPane.serializeValue.setText("zip");
        } else {
            this.noneButton.setEnabled(true);
            this.noneButton.setSelected(true);
            this.bagView.infoInputPane.serializeValue.setText("none");
        }
        this.savePanel.invalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.invalidate();
        this.repaint();
    }

    private static void buildConstraints(GridBagConstraints gbc, int x, int y, int w, int h, int wx, int wy, int fill, int anchor) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.fill = fill;
        gbc.anchor = anchor;
    }

    private String getMessage(String property) {
        return this.bagView.getPropertyMessage(property);
    }

    private class HoleyBagHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private HoleyBagHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox cb = (JCheckBox)e.getSource();
            boolean isSelected = cb.isSelected();
            if (isSelected) {
                SaveBagFrame.this.bagView.getBag().isHoley(true);
                ((SaveBagFrame)SaveBagFrame.this).bagView.infoInputPane.serializeValue.setText("true");
                SaveBagFrame.this.urlLabel.setEnabled(true);
                SaveBagFrame.this.urlField.setEnabled(true);
                SaveBagFrame.this.urlField.requestFocus();
            } else {
                SaveBagFrame.this.bagView.getBag().isHoley(false);
                ((SaveBagFrame)SaveBagFrame.this).bagView.infoInputPane.serializeValue.setText("false");
                SaveBagFrame.this.urlLabel.setEnabled(false);
                SaveBagFrame.this.urlField.setEnabled(false);
            }
        }
    }

    private class PayAlgorithmListHandler
    extends AbstractAction {
        private static final long serialVersionUID = 75893358194076314L;

        private PayAlgorithmListHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox jlist = (JComboBox)e.getSource();
            String alg = (String)jlist.getSelectedItem();
            SaveBagFrame.this.bagView.getBag().setPayloadManifestAlgorithm(alg);
        }
    }

    private class PayloadManifestHandler
    extends AbstractAction {
        private static final long serialVersionUID = 75893358194076314L;

        private PayloadManifestHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox cb = (JCheckBox)e.getSource();
            boolean isSelected = cb.isSelected();
            if (isSelected) {
                SaveBagFrame.this.bagView.getBag().isBuildPayloadManifest(true);
            } else {
                SaveBagFrame.this.bagView.getBag().isBuildPayloadManifest(false);
            }
        }
    }

    private class TagAlgorithmListHandler
    extends AbstractAction {
        private static final long serialVersionUID = 75893358194076314L;

        private TagAlgorithmListHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox jlist = (JComboBox)e.getSource();
            String alg = (String)jlist.getSelectedItem();
            SaveBagFrame.this.bagView.getBag().setTagManifestAlgorithm(alg);
        }
    }

    private class TagManifestHandler
    extends AbstractAction {
        private static final long serialVersionUID = 75893358194076314L;

        private TagManifestHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox cb = (JCheckBox)e.getSource();
            boolean isSelected = cb.isSelected();
            if (isSelected) {
                SaveBagFrame.this.bagView.getBag().isBuildTagManifest(true);
            } else {
                SaveBagFrame.this.bagView.getBag().isBuildTagManifest(false);
            }
        }
    }

    private class CancelSaveBagHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelSaveBagHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SaveBagFrame.this.setVisible(false);
        }
    }

    private class OkSaveBagHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OkSaveBagHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SaveBagFrame.this.bagNameField.getText().trim().isEmpty() || SaveBagFrame.this.bagNameField.getText().equalsIgnoreCase(SaveBagFrame.this.bagView.getPropertyMessage("bag.label.noname"))) {
                BagView.showWarningErrorDialog("Error - bag not saved", "The bag must have a file name.");
                return;
            }
            if (SaveBagFrame.this.bagView.getBag().isHoley()) {
                if (SaveBagFrame.this.urlField.getText().trim().isEmpty()) {
                    BagView.showWarningErrorDialog("Error - bag not saved", "A holey bag must have a URL value.");
                    return;
                }
                SaveBagFrame.this.bagView.getBag().getFetch().setBaseURL(SaveBagFrame.this.urlField.getText().trim());
                ((SaveBagFrame)SaveBagFrame.this).bagView.infoInputPane.holeyValue.setText("true");
            } else {
                ((SaveBagFrame)SaveBagFrame.this).bagView.infoInputPane.holeyValue.setText("false");
            }
            SaveBagFrame.this.setVisible(false);
            SaveBagFrame.this.bagView.getBag().setName(SaveBagFrame.this.bagFileName);
            ((SaveBagFrame)SaveBagFrame.this).bagView.saveBagHandler.save(SaveBagFrame.this.bagFile);
        }
    }

    private class SaveBagAsHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private SaveBagAsHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int option;
            File selectFile = new File(File.separator + ".");
            JFrame frame = new JFrame();
            JFileChooser fs = new JFileChooser(selectFile);
            fs.setDialogType(1);
            fs.setFileSelectionMode(0);
            fs.setDialogTitle("Save Bag As");
            DefaultBag bag = SaveBagFrame.this.bagView.getBag();
            fs.setCurrentDirectory(bag.getRootDir());
            if (bag.getName() != null && !bag.getName().equalsIgnoreCase(SaveBagFrame.this.bagView.getPropertyMessage("bag.label.noname"))) {
                String selectedName = bag.getName();
                if (bag.getSerialMode() == 1) {
                    selectedName = selectedName + ".zip";
                }
                fs.setSelectedFile(new File(selectedName));
            }
            if ((option = fs.showSaveDialog(frame)) == 0) {
                SaveBagFrame.this.bagFile = fs.getSelectedFile();
                SaveBagFrame.this.bagFileName = SaveBagFrame.this.bagFile.getAbsolutePath();
                String name = SaveBagFrame.this.bagFileName;
                ((SaveBagFrame)SaveBagFrame.this).bagView.infoInputPane.setBagName(name);
                SaveBagFrame.this.bagNameField.setText(SaveBagFrame.this.bagFileName);
                SaveBagFrame.this.bagNameField.setCaretPosition(SaveBagFrame.this.bagFileName.length());
                SaveBagFrame.this.bagNameField.invalidate();
            }
        }
    }

    public class SerializeBagHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton cb = (JRadioButton)e.getSource();
            boolean isSel = cb.isSelected();
            if (isSel) {
                if (cb == SaveBagFrame.this.noneButton) {
                    SaveBagFrame.this.bagView.getBag().isSerial(false);
                    SaveBagFrame.this.bagView.getBag().setSerialMode((short)0);
                    ((SaveBagFrame)SaveBagFrame.this).bagView.infoInputPane.serializeValue.setText("none");
                } else if (cb == SaveBagFrame.this.zipButton) {
                    SaveBagFrame.this.bagView.getBag().isSerial(true);
                    SaveBagFrame.this.bagView.getBag().setSerialMode((short)1);
                    ((SaveBagFrame)SaveBagFrame.this).bagView.infoInputPane.serializeValue.setText("zip");
                } else {
                    SaveBagFrame.this.bagView.getBag().isSerial(false);
                    SaveBagFrame.this.bagView.getBag().setSerialMode((short)0);
                    ((SaveBagFrame)SaveBagFrame.this).bagView.infoInputPane.serializeValue.setText("none");
                }
            }
        }
    }
}

