/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.docking.flexdock;

import org.flexdock.docking.DockableFactory;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.drag.effects.DragPreview;
import org.flexdock.docking.drag.effects.EffectsManager;
import org.flexdock.perspective.PerspectiveFactory;
import org.flexdock.perspective.PerspectiveManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.richclient.application.ApplicationPage;
import org.springframework.richclient.application.ApplicationPageFactory;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageDescriptor;
import org.springframework.richclient.application.docking.flexdock.FlexDockApplicationPage;

public class FlexDockApplicationPageFactory
implements ApplicationPageFactory,
InitializingBean {
    private PerspectiveFactory perspectiveFactory;
    private String defaultPerspective;
    private DragPreview dragPreview;
    private boolean floatingEnabled;
    private boolean singleTabsAllowed;

    public String getDefaultPerspective() {
        return this.defaultPerspective;
    }

    public void setDefaultPerspective(String defaultPerspective) {
        this.defaultPerspective = defaultPerspective;
    }

    public ApplicationPage createApplicationPage(ApplicationWindow window, PageDescriptor descriptor) {
        FlexDockApplicationPage page = new FlexDockApplicationPage();
        page.setApplicationWindow(window);
        page.setDescriptor(descriptor);
        DockingManager.setDockableFactory((DockableFactory)page);
        PerspectiveManager.setFactory((PerspectiveFactory)this.perspectiveFactory);
        PerspectiveManager.getInstance().setCurrentPerspective(this.defaultPerspective, true);
        page.loadLayout();
        return page;
    }

    public void setPerspectiveFactory(PerspectiveFactory perspectiveFactory) {
        this.perspectiveFactory = perspectiveFactory;
    }

    public PerspectiveFactory getPerspectiveFactory() {
        return this.perspectiveFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dragPreview != null) {
            EffectsManager.setPreview((DragPreview)this.dragPreview);
        }
        DockingManager.setFloatingEnabled((boolean)this.floatingEnabled);
        DockingManager.setSingleTabsAllowed((boolean)this.singleTabsAllowed);
    }

    public DragPreview getDragPreview() {
        return this.dragPreview;
    }

    public void setDragPreview(DragPreview dragPreview) {
        this.dragPreview = dragPreview;
    }

    public boolean isFloatingEnabled() {
        return this.floatingEnabled;
    }

    public void setFloatingEnabled(boolean floatingEnabled) {
        this.floatingEnabled = floatingEnabled;
    }
}

