/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessor;
import org.springframework.binding.MutablePropertyAccessStrategy;
import org.springframework.binding.support.AbstractPropertyAccessStrategy;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.ValueHolder;
import org.springframework.richclient.beans.DefaultMemberPropertyAccessor;

public class ObjectPropertyAccessStrategy
extends AbstractPropertyAccessStrategy {
    private final DefaultMemberPropertyAccessor propertyAccessor;

    public ObjectPropertyAccessStrategy(Object target) {
        this((ValueModel)new ValueHolder(target));
    }

    public ObjectPropertyAccessStrategy(ValueModel domainObjectHolder) {
        this(domainObjectHolder, false);
    }

    public ObjectPropertyAccessStrategy(ValueModel domainObjectHolder, boolean fieldAccessEnabled) {
        this(domainObjectHolder, fieldAccessEnabled, true);
    }

    public ObjectPropertyAccessStrategy(ValueModel domainObjectHolder, boolean fieldAccessEnabled, boolean strictNullValueHandling) {
        super(domainObjectHolder);
        this.propertyAccessor = new DefaultMemberPropertyAccessor(domainObjectHolder.getValue(), fieldAccessEnabled, strictNullValueHandling);
    }

    protected ObjectPropertyAccessStrategy(ObjectPropertyAccessStrategy parent, String basePropertyPath) {
        super((AbstractPropertyAccessStrategy)parent, basePropertyPath);
        this.propertyAccessor = parent.propertyAccessor;
    }

    protected PropertyAccessor getPropertyAccessor() {
        return this.propertyAccessor;
    }

    public MutablePropertyAccessStrategy getPropertyAccessStrategyForPath(String propertyPath) throws BeansException {
        return new ObjectPropertyAccessStrategy(this, this.getFullPropertyPath(propertyPath));
    }

    public MutablePropertyAccessStrategy newPropertyAccessStrategy(ValueModel domainObjectHolder) {
        return new ObjectPropertyAccessStrategy(domainObjectHolder);
    }

    protected void domainObjectChanged() {
        this.propertyAccessor.setTarget(this.getDomainObject());
    }
}

