/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.springframework.binding.value.IndexAdapter;
import org.springframework.binding.value.support.AbstractIndexAdapter;
import org.springframework.binding.value.support.ObservableList;

public class ObservableEventList
extends TransformedList
implements ObservableList {
    private IndexAdapter indexAdapter;
    protected EventListenerList listenerList = new EventListenerList();

    public ObservableEventList(EventList source) {
        super(source);
        source.addListEventListener((ListEventListener)this);
    }

    protected boolean isWritable() {
        return true;
    }

    public void listChanged(ListEvent listChanges) {
        this.updates.forwardEvent(listChanges);
        while (listChanges.nextBlock()) {
            int startIndex = listChanges.getBlockStartIndex();
            int endIndex = listChanges.getBlockEndIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                this.fireIntervalAdded((Object)this, startIndex, endIndex);
                continue;
            }
            if (changeType == 0) {
                this.fireIntervalRemoved((Object)this, startIndex, endIndex);
                continue;
            }
            if (changeType != 1) continue;
            this.fireContentsChanged((Object)this, startIndex, endIndex);
        }
    }

    public IndexAdapter getIndexAdapter(int index) {
        if (this.indexAdapter == null) {
            this.indexAdapter = new ThisIndexAdapter();
        }
        this.indexAdapter.setIndex(index);
        return this.indexAdapter;
    }

    public int getSize() {
        return this.size();
    }

    public Object getElementAt(int index) {
        return this.get(index);
    }

    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ObservableEventList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(source, 0, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    protected void fireIntervalAdded(Object source, int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ObservableEventList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(source, 1, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalAdded(e);
        }
    }

    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ObservableEventList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(source, 2, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
        }
    }

    private class ThisIndexAdapter
    extends AbstractIndexAdapter {
        private static final int NULL_INDEX = -1;

        private ThisIndexAdapter() {
        }

        public Object getValue() {
            if (this.getIndex() == -1) {
                return null;
            }
            return ObservableEventList.this.get(this.getIndex());
        }

        public void setValue(Object value) {
            if (this.getIndex() == -1) {
                throw new IllegalStateException("Attempt to set value at null index; operation not allowed");
            }
            ObservableEventList.this.set(this.getIndex(), value);
        }

        public void fireIndexedObjectChanged() {
        }
    }
}

