/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.mdi.contextmenu;

import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.springframework.richclient.command.ActionCommand;

public class CascadeCommand
extends ActionCommand {
    private static final String ID = "cascadeCommand";
    private JDesktopPane desktop;
    private int offset;
    private boolean resizeFrames;

    public CascadeCommand(JDesktopPane desktopPane) {
        this(desktopPane, true);
    }

    public CascadeCommand(JDesktopPane desktopPane, int offset) {
        this(desktopPane, offset, true);
    }

    public CascadeCommand(JDesktopPane desktopPane, boolean resizeFrames) {
        this(desktopPane, 20, resizeFrames);
    }

    public CascadeCommand(JDesktopPane desktopPane, int offset, boolean resizeFrames) {
        super(ID);
        this.desktop = desktopPane;
        this.offset = offset;
        this.resizeFrames = resizeFrames;
    }

    protected void doExecuteCommand() {
        int x = 0;
        int y = 0;
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        int frameHeight = this.desktop.getBounds().height - 5 - allFrames.length * this.offset;
        int frameWidth = this.desktop.getBounds().width - 5 - allFrames.length * this.offset;
        for (int i = allFrames.length - 1; i >= 0; --i) {
            JInternalFrame frame = allFrames[i];
            if (frame.isIcon()) {
                try {
                    frame.setIcon(false);
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
            if (this.resizeFrames) {
                frame.setSize(frameWidth, frameHeight);
            }
            frame.setLocation(x, y);
            x += this.offset;
            y += this.offset;
        }
    }
}

