/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.components;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;

public class ShuttleList
extends JPanel {
    private boolean showEditButton = false;
    private JList helperList = new JList();
    private JList sourceList = new JList();
    private JLabel sourceLabel = new JLabel();
    private JPanel sourcePanel = new JPanel(new BorderLayout());
    private JPanel chosenPanel = new JPanel(new BorderLayout());
    private JList chosenList = new JList();
    private JLabel chosenLabel = new JLabel();
    private JScrollPane helperScroller = new JScrollPane(this.helperList);
    private JPanel buttonPanel;
    private JButton editButton;
    private ListModel dataModel;
    private Comparator comparator;
    private boolean panelsShowing;
    private static final long serialVersionUID = -6038138479095186130L;
    private JButton leftToRight;
    private JButton allLeftToRight;
    private JButton rightToLeft;
    private JButton allRightToLeft;

    public ShuttleList() {
        this(true);
    }

    public ShuttleList(boolean showEditButton) {
        this.showEditButton = showEditButton;
        this.panelsShowing = !showEditButton;
        this.buildComponent();
    }

    public ListCellRenderer getCellRenderer() {
        return this.sourceList.getCellRenderer();
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        this.sourceList.setCellRenderer(cellRenderer);
        this.chosenList.setCellRenderer(cellRenderer);
        this.helperList.setCellRenderer(cellRenderer);
    }

    public ListModel getModel() {
        return this.dataModel;
    }

    public void setModel(ListModel model) {
        this.helperList.setModel(model);
        this.dataModel = model;
        this.clearSelection();
        Dimension d = this.helperScroller.getPreferredSize();
        this.chosenPanel.setPreferredSize(d);
        this.sourcePanel.setPreferredSize(d);
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.sourceList.setVisibleRowCount(visibleRowCount);
        this.chosenList.setVisibleRowCount(visibleRowCount);
        this.helperList.setVisibleRowCount(visibleRowCount);
        Dimension d = this.helperScroller.getPreferredSize();
        this.chosenPanel.setPreferredSize(d);
        this.sourcePanel.setPreferredSize(d);
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void setEditIcon(Icon editIcon, String text) {
        if (editIcon != null) {
            this.editButton.setIcon(editIcon);
            if (text != null) {
                this.editButton.setToolTipText(text);
            }
            this.editButton.setText("");
        } else {
            this.editButton.setIcon(null);
            if (text != null) {
                this.editButton.setText(text);
            }
        }
    }

    public void setListLabels(String chosenLabel, String sourceLabel) {
        if (chosenLabel != null) {
            this.chosenLabel.setText(chosenLabel);
            this.chosenLabel.setVisible(true);
        } else {
            this.chosenLabel.setVisible(false);
        }
        if (sourceLabel != null) {
            this.sourceLabel.setText(sourceLabel);
            this.sourceLabel.setVisible(true);
        } else {
            this.sourceLabel.setVisible(false);
        }
        Dimension d = this.chosenList.getPreferredSize();
        Dimension d1 = this.chosenLabel.getPreferredSize();
        Dimension dChosenPanel = this.chosenPanel.getPreferredSize();
        dChosenPanel.width = Math.max(d.width, Math.max(dChosenPanel.width, d1.width));
        this.chosenPanel.setPreferredSize(dChosenPanel);
        Dimension dSourceList = this.sourceList.getPreferredSize();
        Dimension dSource = this.sourceLabel.getPreferredSize();
        Dimension dSourcePanel = this.sourcePanel.getPreferredSize();
        dSourcePanel.width = Math.max(dSource.width, Math.max(dSourceList.width, dSourcePanel.width));
        this.sourcePanel.setPreferredSize(dSourcePanel);
        Dimension fullPanelSize = this.getPreferredSize();
        fullPanelSize.width = dSourcePanel.width + dChosenPanel.width + (this.editButton != null ? this.editButton.getPreferredSize().width : 0) + (this.buttonPanel != null ? this.buttonPanel.getPreferredSize().width : 0) + 20;
        this.setPreferredSize(fullPanelSize);
    }

    protected JComponent buildComponent() {
        this.helperList.setSelectionMode(2);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        this.editButton = new JButton("Edit...");
        this.editButton.setIconTextGap(0);
        this.editButton.setMargin(new Insets(2, 4, 2, 4));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ShuttleList.this.togglePanels();
            }
        });
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 3);
        gbc.anchor = 18;
        gbl.setConstraints(this.editButton, gbc);
        this.add(this.editButton);
        this.sourceList.setSelectionMode(2);
        this.sourceList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 39) {
                    ShuttleList.this.moveLeftToRight();
                }
            }
        });
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.sourcePanel.add("North", this.sourceLabel);
        JScrollPane sourceScroller = new JScrollPane(this.sourceList);
        this.sourcePanel.add("Center", sourceScroller);
        gbl.setConstraints(this.sourcePanel, gbc);
        this.add(this.sourcePanel);
        JPanel buttonPanel = this.buildButtonPanel();
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbl.setConstraints(buttonPanel, gbc);
        this.add(buttonPanel);
        this.chosenList.setSelectionMode(2);
        this.chosenList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 37) {
                    ShuttleList.this.moveRightToLeft();
                }
            }
        });
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.chosenPanel.add("North", this.chosenLabel);
        JScrollPane chosenScroller = new JScrollPane(this.chosenList);
        this.chosenPanel.add("Center", chosenScroller);
        gbl.setConstraints(this.chosenPanel, gbc);
        this.add(this.chosenPanel);
        this.editButton.setVisible(this.showEditButton);
        this.buttonPanel.setVisible(this.panelsShowing);
        this.sourcePanel.setVisible(this.panelsShowing);
        return this;
    }

    protected JPanel buildButtonPanel() {
        this.buttonPanel = new JPanel();
        this.leftToRight = new JButton(">");
        this.allLeftToRight = new JButton(">>");
        this.rightToLeft = new JButton("<");
        this.allRightToLeft = new JButton("<<");
        Font smallerFont = this.leftToRight.getFont().deriveFont(9.0f);
        this.leftToRight.setFont(smallerFont);
        this.allLeftToRight.setFont(smallerFont);
        this.rightToLeft.setFont(smallerFont);
        this.allRightToLeft.setFont(smallerFont);
        Insets margin = new Insets(2, 4, 2, 4);
        this.leftToRight.setMargin(margin);
        this.allLeftToRight.setMargin(margin);
        this.rightToLeft.setMargin(margin);
        this.allRightToLeft.setMargin(margin);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.buttonPanel.setLayout(gbl);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbl.setConstraints(this.leftToRight, gbc);
        gbl.setConstraints(this.allLeftToRight, gbc);
        gbl.setConstraints(this.rightToLeft, gbc);
        gbl.setConstraints(this.allRightToLeft, gbc);
        this.buttonPanel.add(this.leftToRight);
        this.buttonPanel.add(this.allLeftToRight);
        this.buttonPanel.add(this.rightToLeft);
        this.buttonPanel.add(this.allRightToLeft);
        this.leftToRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ShuttleList.this.moveLeftToRight();
            }
        });
        this.allLeftToRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ShuttleList.this.moveAllLeftToRight();
            }
        });
        this.rightToLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ShuttleList.this.moveRightToLeft();
            }
        });
        this.allRightToLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ShuttleList.this.moveAllRightToLeft();
            }
        });
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return this.buttonPanel;
    }

    public void togglePanels() {
        this.panelsShowing = !this.panelsShowing;
        this.sourcePanel.setVisible(this.panelsShowing);
        this.buttonPanel.setVisible(this.panelsShowing);
    }

    protected void moveLeftToRight() {
        Object[] sourceSelected = this.sourceList.getSelectedValues();
        int nSourceSelected = sourceSelected.length;
        int[] currentSelection = this.helperList.getSelectedIndices();
        int[] newSelection = new int[currentSelection.length + nSourceSelected];
        System.arraycopy(currentSelection, 0, newSelection, 0, currentSelection.length);
        int destPos = currentSelection.length;
        for (int i = 0; i < sourceSelected.length; ++i) {
            newSelection[destPos++] = this.indexOf(sourceSelected[i]);
        }
        this.helperList.setSelectedIndices(newSelection);
        this.update();
    }

    protected void moveAllLeftToRight() {
        int sz = this.dataModel.getSize();
        int[] selected = new int[sz];
        for (int i = 0; i < sz; ++i) {
            selected[i] = i;
        }
        this.helperList.setSelectedIndices(selected);
        this.update();
    }

    protected void moveRightToLeft() {
        Object[] chosenSelectedValues = this.chosenList.getSelectedValues();
        int nChosenSelected = chosenSelectedValues.length;
        int[] chosenSelected = new int[nChosenSelected];
        if (nChosenSelected == 0) {
            return;
        }
        int[] currentSelected = this.helperList.getSelectedIndices();
        int nCurrentSelected = currentSelected.length;
        for (int i = 0; i < nChosenSelected; ++i) {
            chosenSelected[i] = this.indexOf(chosenSelectedValues[i]);
        }
        int[] newSelection = new int[nCurrentSelected - nChosenSelected];
        int newSelPos = 0;
        int chosenPos = 0;
        for (int i = 0; i < nCurrentSelected; ++i) {
            int currentIdx = currentSelected[i];
            if (chosenPos < nChosenSelected && currentIdx == chosenSelected[chosenPos]) {
                ++chosenPos;
                continue;
            }
            newSelection[newSelPos++] = currentIdx;
        }
        this.helperList.setSelectedIndices(newSelection);
        this.update();
    }

    protected void moveAllRightToLeft() {
        this.clearSelection();
    }

    protected int indexOf(Object o) {
        int size = this.dataModel.getSize();
        for (int i = 0; i < size; ++i) {
            if (!(this.comparator == null ? o.equals(this.dataModel.getElementAt(i)) : this.comparator.compare(o, this.dataModel.getElementAt(i)) == 0)) continue;
            return i;
        }
        return -1;
    }

    protected void update() {
        int i;
        int sz = this.dataModel.getSize();
        int[] selected = this.helperList.getSelectedIndices();
        ArrayList sourceItems = new ArrayList(sz);
        ArrayList chosenItems = new ArrayList(selected.length);
        for (i = 0; i < sz; ++i) {
            sourceItems.add(this.dataModel.getElementAt(i));
        }
        for (i = selected.length - 1; i >= 0; --i) {
            chosenItems.add(sourceItems.remove(selected[i]));
        }
        Collections.reverse(chosenItems);
        this.sourceList.setListData(sourceItems.toArray());
        this.chosenList.setListData(chosenItems.toArray());
    }

    public ListSelectionModel getSelectionModel() {
        return this.helperList.getSelectionModel();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.helperList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.helperList.removeListSelectionListener(listener);
    }

    public void clearSelection() {
        this.helperList.clearSelection();
        this.update();
    }

    public void setSelectedIndices(int[] indices) {
        this.helperList.setSelectedIndices(indices);
        this.update();
    }

    public Object[] getSelectedValues() {
        return this.helperList.getSelectedValues();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.helperList.setEnabled(enabled);
        this.sourceList.setEnabled(enabled);
        this.chosenList.setEnabled(enabled);
        this.buttonPanel.setEnabled(enabled);
        this.leftToRight.setEnabled(enabled);
        this.allLeftToRight.setEnabled(enabled);
        this.rightToLeft.setEnabled(enabled);
        this.allRightToLeft.setEnabled(enabled);
    }
}

