/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.core;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Map;
import org.springframework.core.MethodParameter;

public abstract class GenericCollectionTypeResolver
extends org.springframework.core.GenericCollectionTypeResolver {
    public static Class getCollectionType(Class collectionClass) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.extractType(collectionClass, Collection.class, 0));
    }

    public static Class getMapKeyType(Class mapClass) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.extractType(mapClass, Map.class, 0));
    }

    public static Class getMapValueType(Class mapClass) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.extractType(mapClass, Map.class, 1));
    }

    public static Class getCollectionFieldType(Field collectionField) {
        return GenericCollectionTypeResolver.getGenericFieldType(collectionField, 0, 0);
    }

    public static Class getCollectionFieldType(Field collectionField, int nestingLevel) {
        return GenericCollectionTypeResolver.getGenericFieldType(collectionField, 0, nestingLevel);
    }

    public static Class getMapKeyFieldType(Field mapField) {
        return GenericCollectionTypeResolver.getGenericFieldType(mapField, 0, 0);
    }

    public static Class getMapKeyFieldType(Field mapField, int nestingLevel) {
        return GenericCollectionTypeResolver.getGenericFieldType(mapField, 0, nestingLevel);
    }

    public static Class getMapValueFieldType(Field mapField) {
        return GenericCollectionTypeResolver.getGenericFieldType(mapField, 1, 0);
    }

    public static Class getMapValueFieldType(Field mapField, int nestingLevel) {
        return GenericCollectionTypeResolver.getGenericFieldType(mapField, 1, nestingLevel);
    }

    public static Class getCollectionParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.getGenericParameterType(methodParam, 0));
    }

    public static Class getMapKeyParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.getGenericParameterType(methodParam, 0));
    }

    public static Class getMapValueParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.getGenericParameterType(methodParam, 1));
    }

    public static Class getCollectionReturnType(Method method) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.getGenericReturnType(method, 0, 1));
    }

    public static Class getCollectionReturnType(Method method, int nestingLevel) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.getGenericReturnType(method, 0, nestingLevel));
    }

    public static Class getMapKeyReturnType(Method method) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.getGenericReturnType(method, 0, 1));
    }

    public static Class getMapKeyReturnType(Method method, int nestingLevel) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.getGenericReturnType(method, 0, nestingLevel));
    }

    public static Class getMapValueReturnType(Method method) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.getGenericReturnType(method, 1, 1));
    }

    public static Class getMapValueReturnType(Method method, int nestingLevel) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.getGenericReturnType(method, 1, nestingLevel));
    }

    public static Class getIndexedValueFieldType(Field field) {
        return GenericCollectionTypeResolver.getIndexedValueFieldType(field, 1);
    }

    public static Class getIndexedValueFieldType(Field field, int nestingLevel) {
        return GenericCollectionTypeResolver.getGenericIndexedValueType(field.getGenericType(), nestingLevel);
    }

    public static Class getIndexedValueMethodType(MethodParameter methodParameter) {
        return GenericCollectionTypeResolver.getIndexedValueMethodType(methodParameter, methodParameter.getNestingLevel());
    }

    public static Class getIndexedValueMethodType(MethodParameter methodParameter, int nestingLevel) {
        Type type = null;
        Method method = methodParameter.getMethod();
        type = method != null ? (methodParameter.getParameterIndex() >= 0 ? method.getGenericParameterTypes()[methodParameter.getParameterIndex()] : method.getGenericReturnType()) : methodParameter.getConstructor().getGenericParameterTypes()[methodParameter.getParameterIndex()];
        return GenericCollectionTypeResolver.getGenericIndexedValueType(type, nestingLevel);
    }

    private static Class getGenericParameterType(MethodParameter methodParam, int typeIndex) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.extractType(methodParam, GenericCollectionTypeResolver.getTargetType(methodParam), typeIndex, methodParam.getNestingLevel()));
    }

    private static Type getTargetType(MethodParameter methodParam) {
        if (methodParam.getConstructor() != null) {
            return methodParam.getConstructor().getGenericParameterTypes()[methodParam.getParameterIndex()];
        }
        if (methodParam.getParameterIndex() >= 0) {
            return methodParam.getMethod().getGenericParameterTypes()[methodParam.getParameterIndex()];
        }
        return methodParam.getMethod().getGenericReturnType();
    }

    private static Class getSourceClass(Type type) {
        Class sourceClass;
        if (Collection.class.isAssignableFrom(sourceClass = GenericCollectionTypeResolver.toClass(type))) {
            return Collection.class;
        }
        if (Map.class.isAssignableFrom(sourceClass)) {
            return Map.class;
        }
        return sourceClass;
    }

    private static Class getGenericFieldType(Field field, int typeIndex, int nestingLevel) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.extractType(null, field.getGenericType(), typeIndex, nestingLevel));
    }

    private static Class getGenericReturnType(Method method, int typeIndex, int nestingLevel) {
        return GenericCollectionTypeResolver.toClass(GenericCollectionTypeResolver.extractType(null, method.getGenericReturnType(), typeIndex, nestingLevel));
    }

    private static Class getGenericIndexedValueType(Type type, int nestingLevel) {
        Class actualType = GenericCollectionTypeResolver.toClass(type);
        for (int i = 0; i < nestingLevel; ++i) {
            if (actualType.isArray()) {
                type = type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : actualType.getComponentType();
            } else if ((class$java$util$Collection == null ? GenericCollectionTypeResolver.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(actualType)) {
                type = GenericCollectionTypeResolver.extractType(type, class$java$util$Collection == null ? GenericCollectionTypeResolver.class$("java.util.Collection") : class$java$util$Collection, 0);
            } else if ((class$java$util$Map == null ? GenericCollectionTypeResolver.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(actualType)) {
                type = GenericCollectionTypeResolver.extractType(type, class$java$util$Map == null ? GenericCollectionTypeResolver.class$("java.util.Map") : class$java$util$Map, 1);
            }
            actualType = GenericCollectionTypeResolver.toClass(type);
        }
        return actualType;
    }

    private static Type extractType(MethodParameter methodParameter, Type type, int typeIndex, int nestingLevel) {
        for (int i = 0; i <= nestingLevel; ++i) {
            Integer currentTypeIndex;
            Integer n = currentTypeIndex = methodParameter != null ? methodParameter.getTypeIndexForLevel(i) : null;
            int indexToUse = currentTypeIndex != null ? currentTypeIndex : (i == nestingLevel ? typeIndex : GenericCollectionTypeResolver.getValueTypeIndex(type));
            type = GenericCollectionTypeResolver.extractType(type, GenericCollectionTypeResolver.getSourceClass(type), indexToUse);
        }
        return type;
    }

    private static int getValueTypeIndex(Type type) {
        return GenericCollectionTypeResolver.getSourceClass(type) == Map.class ? 1 : 0;
    }

    private static Type extractType(Type type, Class source, int typeIndex) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type actualType = GenericCollectionTypeResolver.getActualType(parameterizedType, source, typeIndex);
            if (actualType != null) {
                return actualType;
            }
            type = parameterizedType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            if (typeIndex == 0) {
                return ((GenericArrayType)type).getGenericComponentType();
            }
            return null;
        }
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (classType.isArray()) {
                return classType.getComponentType();
            }
            Type returnType = GenericCollectionTypeResolver.extractType(classType.getGenericSuperclass(), source, typeIndex);
            if (returnType != null) {
                return returnType;
            }
            Type[] genericInterfaces = classType.getGenericInterfaces();
            for (int i = 0; i < genericInterfaces.length; ++i) {
                returnType = GenericCollectionTypeResolver.extractType(genericInterfaces[i], source, typeIndex);
                if (returnType == null) continue;
                return returnType;
            }
        }
        return null;
    }

    public static Type getActualType(ParameterizedType type, Class superType, int typeIndex) {
        if (superType.equals(type.getRawType())) {
            return type.getActualTypeArguments()[typeIndex];
        }
        if (!(type.getRawType() instanceof Class)) {
            return null;
        }
        Class rawType = (Class)type.getRawType();
        Type genericSuperclass = rawType.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            Type actualType = GenericCollectionTypeResolver.getActualType((ParameterizedType)genericSuperclass, superType, typeIndex);
            if (actualType instanceof TypeVariable) {
                actualType = GenericCollectionTypeResolver.getActualType((TypeVariable)actualType, rawType.getTypeParameters(), type.getActualTypeArguments());
            }
            if (actualType != null) {
                return actualType;
            }
        }
        Type[] genericInterfaces = ((Class)type.getRawType()).getGenericInterfaces();
        for (int i = 0; i < genericInterfaces.length; ++i) {
            if (!(genericInterfaces[i] instanceof ParameterizedType)) continue;
            Type actualType = GenericCollectionTypeResolver.getActualType((ParameterizedType)genericInterfaces[i], superType, typeIndex);
            if (actualType instanceof TypeVariable) {
                actualType = GenericCollectionTypeResolver.getActualType((TypeVariable)actualType, rawType.getTypeParameters(), type.getActualTypeArguments());
            }
            if (actualType == null) continue;
            return actualType;
        }
        return null;
    }

    private static Type getActualType(TypeVariable typeVariable, TypeVariable[] typeVariables, Type[] actualTypeArguments) {
        if (typeVariable == null) {
            return null;
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            if (!typeVariables[i].equals(typeVariable)) continue;
            return actualTypeArguments[i];
        }
        return null;
    }

    public static Class toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return GenericCollectionTypeResolver.toClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return GenericCollectionTypeResolver.toClass(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return GenericCollectionTypeResolver.toClass(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(GenericCollectionTypeResolver.toClass(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        return Object.class;
    }
}

