/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.support.CustomBinding;
import org.springframework.richclient.swing.BigDecimalTextField;
import org.springframework.richclient.swing.UserInputListener;

public class NumberBinding
extends CustomBinding
implements UserInputListener {
    protected final BigDecimalTextField numberField;
    protected final boolean readOnly;
    private final String leftDecoration;
    private final String rightDecoration;
    private final BigDecimal shiftFactor;
    private int shiftScale;
    private boolean isSettingValue = false;

    public NumberBinding(Class requiredClass, BigDecimalTextField component, boolean readOnly, String leftDecoration, String rightDecoration, BigDecimal shiftFactor, int shiftScale, FormModel formModel, String formPropertyPath) {
        super(formModel, formPropertyPath, requiredClass);
        this.numberField = component;
        this.readOnly = readOnly;
        this.leftDecoration = leftDecoration;
        this.rightDecoration = rightDecoration;
        this.shiftFactor = shiftFactor;
        this.shiftScale = shiftScale;
    }

    protected void valueModelChanged(Object newValue) {
        this.isSettingValue = true;
        if (this.shiftFactor != null && newValue != null) {
            this.numberField.setValue(((BigDecimal)newValue).multiply(this.shiftFactor));
        } else {
            this.numberField.setValue((Number)newValue);
        }
        this.readOnlyChanged();
        this.isSettingValue = false;
    }

    protected JComponent doBindControl() {
        this.valueModelChanged(this.getValue());
        this.numberField.addUserInputListener(this);
        if (this.leftDecoration == null && this.rightDecoration == null) {
            return this.numberField;
        }
        return this.createPanelWithDecoration();
    }

    public void update(JComponent component) {
        if (!this.isSettingValue && this.numberField.isEditable()) {
            Number value = this.numberField.getValue();
            if (value != null && this.shiftFactor != null) {
                this.controlValueChanged(((BigDecimal)value).divide(this.shiftFactor, this.shiftScale, 0));
            } else {
                this.controlValueChanged(value);
            }
        }
    }

    private JComponent createPanelWithDecoration() {
        StringBuffer columnLayout = new StringBuffer();
        if (this.leftDecoration != null) {
            columnLayout.append("pref, 3dlu, ");
        }
        columnLayout.append("fill:pref:grow");
        if (this.rightDecoration != null) {
            columnLayout.append(", 3dlu, pref");
        }
        JPanel panel = new JPanel((LayoutManager)new FormLayout(columnLayout.toString(), "fill:pref:grow")){

            public void requestFocus() {
                NumberBinding.this.numberField.requestFocus();
            }
        };
        CellConstraints cc = new CellConstraints();
        int columnIndex = 1;
        if (this.leftDecoration != null) {
            panel.add((Component)new JLabel(this.leftDecoration), cc.xy(columnIndex, 1));
            columnIndex += 2;
        }
        panel.add((Component)this.numberField, cc.xy(columnIndex, 1));
        if (this.rightDecoration != null) {
            panel.add((Component)new JLabel(this.rightDecoration), cc.xy(columnIndex += 2, 1));
        }
        return panel;
    }

    protected void readOnlyChanged() {
        this.numberField.setEditable(this.isEnabled() && !this.readOnly && !this.isReadOnly());
    }

    protected void enabledChanged() {
        this.numberField.setEnabled(this.isEnabled());
        this.readOnlyChanged();
    }
}

