/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.preference;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.richclient.dialog.DialogPage;
import org.springframework.richclient.dialog.TitledPageApplicationDialog;
import org.springframework.richclient.dialog.TreeCompositeDialogPage;
import org.springframework.richclient.preference.PreferencePage;
import org.springframework.richclient.settings.Settings;
import org.springframework.util.Assert;

public class PreferenceDialog
extends TitledPageApplicationDialog {
    private List preferencePages = new ArrayList();
    private Settings settings;

    public PreferenceDialog() {
        this("preferenceDialog");
    }

    public PreferenceDialog(String dialogId) {
        super((DialogPage)new TreeCompositeDialogPage(dialogId));
    }

    private void addPage(PreferencePage page) {
        Assert.isTrue((!this.isControlCreated() ? 1 : 0) != 0, (String)"Add pages before control is created.");
        this.preferencePages.add(page);
        page.setPreferenceDialog(this);
    }

    public void addPreferencePage(PreferencePage page) {
        this.addPage(page);
        this.getPageContainer().addPage((DialogPage)page);
    }

    public void addPreferencePage(PreferencePage parent, PreferencePage page) {
        this.addPage(page);
        this.getPageContainer().addPage((DialogPage)parent, (DialogPage)page);
    }

    private TreeCompositeDialogPage getPageContainer() {
        return (TreeCompositeDialogPage)this.getDialogPage();
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean onFinish() {
        Iterator iter = this.preferencePages.iterator();
        while (iter.hasNext()) {
            PreferencePage page = (PreferencePage)((Object)iter.next());
            if (page.onFinish()) continue;
            return false;
        }
        if (this.settings != null) {
            try {
                this.settings.save();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void setSettings(Settings settings) {
        Assert.notNull((Object)settings, (String)"Settings cannot be null.");
        this.settings = settings;
    }
}

