/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.preference;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.config.ApplicationObjectConfigurer;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.dialog.MessageDialog;
import org.springframework.richclient.preference.PreferenceDialog;
import org.springframework.richclient.preference.PreferencePage;
import org.springframework.richclient.settings.SettingsException;
import org.springframework.richclient.settings.SettingsManager;

public class PreferenceManager {
    private PreferenceDialog dialog;
    private List preferencePages = new ArrayList();
    private SettingsManager settingsManager;
    private ApplicationObjectConfigurer objectConfigurer;

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
            Iterator iter = this.preferencePages.iterator();
            while (iter.hasNext()) {
                PreferencePage page = (PreferencePage)((Object)iter.next());
                if (page.getParent() == null) {
                    this.dialog.addPreferencePage(page);
                    continue;
                }
                this.dialog.addPreferencePage(page.getParent(), page);
            }
            try {
                this.dialog.setSettings(this.settingsManager.getUserSettings());
            }
            catch (SettingsException e) {
                new MessageDialog("Error", (Message)new DefaultMessage(e.getMessage(), Severity.ERROR)).showDialog();
                e.printStackTrace();
            }
        }
        if (this.dialog != null) {
            this.dialog.showDialog();
        }
    }

    protected PreferenceDialog createDialog() {
        PreferenceDialog dialog = new PreferenceDialog();
        this.getObjectConfigurer().configure((Object)dialog, "preferenceDialog");
        return dialog;
    }

    public ApplicationObjectConfigurer getObjectConfigurer() {
        if (this.objectConfigurer == null) {
            this.objectConfigurer = (ApplicationObjectConfigurer)ApplicationServicesLocator.services().getService(ApplicationObjectConfigurer.class);
        }
        return this.objectConfigurer;
    }

    public void setObjectConfigurer(ApplicationObjectConfigurer objectConfigurer) {
        this.objectConfigurer = objectConfigurer;
    }

    public void setPreferencePages(List pages) {
        this.preferencePages = pages;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }
}

