/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.selection.binding.support;

import ca.odell.glazedlists.EventList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.springframework.binding.value.ValueModel;
import org.springframework.util.Assert;

public class ValueModel2EventListBridge {
    private boolean manualSynchronize;
    private ValueModel valueModel;
    private EventList eventList;
    private PropertyChangeListener valueChangeHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            ValueModel2EventListBridge.this.synchronize();
        }
    };

    public ValueModel2EventListBridge(ValueModel valueModel, EventList eventList) {
        this(valueModel, eventList, false);
    }

    public ValueModel2EventListBridge(ValueModel valueModel, EventList eventList, boolean manualSynchronize) {
        Assert.notNull((Object)valueModel, (String)"valueModel is required");
        Assert.notNull((Object)eventList, (String)"eventList is required");
        this.valueModel = valueModel;
        this.eventList = eventList;
        this.manualSynchronize = manualSynchronize;
        if (!manualSynchronize) {
            this.synchronize();
            valueModel.addValueChangeListener(this.valueChangeHandler);
        }
    }

    public void synchronize() {
        System.out.println(Thread.currentThread().getName());
        this.eventList.clear();
        Object value = this.valueModel.getValue();
        if (value != null) {
            Assert.isInstanceOf((Class)Collection.class, (Object)value, (String)"The value in the ValueModel is not a Collection");
            this.eventList.addAll((Collection)value);
        }
    }

    public void dispose() {
        if (!this.manualSynchronize) {
            this.valueModel.removeValueChangeListener(this.valueChangeHandler);
        }
    }

    public ValueModel getValueModel() {
        return this.valueModel;
    }

    public EventList getEventList() {
        return this.eventList;
    }
}

