/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.richclient.settings.Settings;
import org.springframework.richclient.util.ClassUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractSettings
implements Settings {
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Map defaults = new HashMap();
    private Map children = new HashMap();
    private String name;
    private Settings parent;
    private boolean childSettingsLoaded = false;
    private Set childSettingNames = new HashSet();

    public AbstractSettings(Settings parent, String name) {
        this.name = name;
        this.parent = parent;
    }

    public boolean contains(String key) {
        return this.internalContains(key) || this.defaults.containsKey(key);
    }

    protected abstract boolean internalContains(String var1);

    protected abstract String[] internalGetChildSettings();

    public void setString(String key, String value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        String old = this.getString(key);
        this.internalSet(key, value);
        this.afterSet(key, old, value);
    }

    protected abstract Settings internalCreateChild(String var1);

    public String[] getChildSettings() {
        if (!this.childSettingsLoaded) {
            this.childSettingsLoaded = true;
            this.childSettingNames.addAll(Arrays.asList(this.internalGetChildSettings()));
        }
        return this.childSettingNames.toArray(new String[this.childSettingNames.size()]);
    }

    public Settings getSettings(String name) {
        if (!this.children.containsKey(name)) {
            this.children.put(name, this.internalCreateChild(name));
            this.childSettingNames.add(name);
        }
        return (Settings)this.children.get(name);
    }

    protected abstract void internalSet(String var1, String var2);

    protected abstract String internalGet(String var1);

    public String getString(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        String value = this.internalGet(key);
        if (!StringUtils.hasText((String)value)) {
            return this.getDefaultString(key);
        }
        return value;
    }

    public void setDefaultString(String key, String value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        this.defaults.put(key, value);
    }

    public String getDefaultString(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        if (!this.defaults.containsKey(key)) {
            return "";
        }
        return (String)this.defaults.get(key);
    }

    public void setInt(String key, int value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        int old = this.getInt(key);
        this.internalSet(key, String.valueOf(value));
        this.afterSet(key, new Integer(old), new Integer(value));
    }

    public int getInt(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        String value = this.internalGet(key);
        if (!StringUtils.hasText((String)value)) {
            return this.getDefaultInt(key);
        }
        return Integer.parseInt(value);
    }

    public void setDefaultInt(String key, int value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        this.defaults.put(key, String.valueOf(value));
    }

    public int getDefaultInt(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        if (!this.defaults.containsKey(key)) {
            return 0;
        }
        return Integer.parseInt((String)this.defaults.get(key));
    }

    public void setDefaultLong(String key, long value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        this.defaults.put(key, String.valueOf(value));
    }

    public long getDefaultLong(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        if (!this.defaults.containsKey(key)) {
            return 0L;
        }
        return Long.parseLong((String)this.defaults.get(key));
    }

    public void setFloat(String key, float value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        float old = this.getFloat(key);
        this.internalSet(key, String.valueOf(value));
        this.afterSet(key, new Float(old), new Float(value));
    }

    public float getFloat(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        String value = this.internalGet(key);
        if (!StringUtils.hasText((String)value)) {
            return this.getDefaultFloat(key);
        }
        return Float.parseFloat(value);
    }

    public void setDefaultFloat(String key, float value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        this.defaults.put(key, String.valueOf(value));
    }

    public float getDefaultFloat(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        if (!this.defaults.containsKey(key)) {
            return 0.0f;
        }
        return Float.parseFloat((String)this.defaults.get(key));
    }

    public void setDouble(String key, double value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        double old = this.getDouble(key);
        this.internalSet(key, String.valueOf(value));
        this.afterSet(key, new Double(old), new Double(value));
    }

    public double getDouble(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        String value = this.internalGet(key);
        if (!StringUtils.hasText((String)value)) {
            return this.getDefaultDouble(key);
        }
        return Double.parseDouble(value);
    }

    public void setDefaultDouble(String key, double value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        this.defaults.put(key, String.valueOf(value));
    }

    public double getDefaultDouble(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        if (!this.defaults.containsKey(key)) {
            return 0.0;
        }
        return Double.parseDouble((String)this.defaults.get(key));
    }

    public void setBoolean(String key, boolean value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        boolean old = this.getBoolean(key);
        this.internalSet(key, String.valueOf(value));
        this.afterSet(key, old, value);
    }

    public boolean getBoolean(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        String value = this.internalGet(key);
        if (!StringUtils.hasText((String)value)) {
            return this.getDefaultBoolean(key);
        }
        return Boolean.valueOf(value);
    }

    public void setDefaultBoolean(String key, boolean value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        if (value) {
            this.defaults.put(key, String.valueOf(value));
        } else {
            this.defaults.remove(key);
        }
        this.removeIfDefault(key);
    }

    public boolean getDefaultBoolean(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        if (!this.defaults.containsKey(key)) {
            return false;
        }
        return Boolean.valueOf((String)this.defaults.get(key));
    }

    public void setLabeledEnum(String key, LabeledEnum value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        LabeledEnum old = this.getLabeledEnum(key);
        this.internalSet(key, this.enumToString(value));
        this.afterSet(key, old, value);
    }

    private LabeledEnum stringToEnum(String s) {
        if (s == null || s.trim().equals("")) {
            return null;
        }
        return (LabeledEnum)ClassUtils.getFieldValue((String)s);
    }

    private String enumToString(LabeledEnum e) {
        return e == null ? "" : ClassUtils.getClassFieldNameWithValue(e.getClass(), (Object)e);
    }

    public LabeledEnum getLabeledEnum(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        String value = this.internalGet(key);
        if (!StringUtils.hasText((String)value)) {
            return this.getDefaultLabeledEnum(key);
        }
        return this.stringToEnum(value);
    }

    public void setDefaultLabeledEnum(String key, LabeledEnum value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        this.defaults.put(key, this.enumToString(value));
    }

    public LabeledEnum getDefaultLabeledEnum(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        return this.stringToEnum((String)this.defaults.get(key));
    }

    public boolean isDefault(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        return this.internalGet(key) == null || ObjectUtils.nullSafeEquals((Object)this.internalGet(key), this.defaults.get(key));
    }

    public String[] getDefaultKeys() {
        return this.defaults.keySet().toArray(new String[0]);
    }

    public String[] getAllKeys() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(Arrays.asList(this.getKeys()));
        keys.addAll(this.defaults.keySet());
        return keys.toArray(new String[0]);
    }

    public String getName() {
        return this.name;
    }

    public Settings getParent() {
        return this.parent;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String key, PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(key, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String key, PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(key, l);
    }

    private void afterSet(String key, Object oldValue, Object newValue) {
        this.removeIfDefault(key);
        this.firePropertyChange(key, oldValue, newValue);
    }

    private void firePropertyChange(String key, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(key, oldValue, newValue);
    }

    protected abstract void internalRemove(String var1);

    private void removeIfDefault(String key) {
        if (this.isDefault(key)) {
            this.internalRemove(key);
        }
    }

    public void remove(String key) {
        if (this.contains(key)) {
            this.internalRemove(key);
        }
    }

    public void setLong(String key, long value) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        long old = this.getLong(key);
        this.internalSet(key, String.valueOf(value));
        this.afterSet(key, new Long(old), new Long(value));
    }

    public long getLong(String key) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        String value = this.internalGet(key);
        if (!StringUtils.hasText((String)value)) {
            return this.getDefaultLong(key);
        }
        return Long.parseLong(value);
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public void removeSettings() {
        this.internalRemoveSettings();
        if (this.getParent() instanceof AbstractSettings) {
            ((AbstractSettings)this.getParent()).childSettingNames.remove(this.getName());
        }
    }

    protected abstract void internalRemoveSettings();
}

