/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.richclient.settings.Settings;
import org.springframework.richclient.settings.SettingsException;
import org.springframework.richclient.settings.SettingsFactory;
import org.springframework.richclient.settings.TransientSettingsFactory;

public class SettingsManager {
    private SettingsFactory settingsFactory = new TransientSettingsFactory();
    private Settings internalSettings;
    private Settings userSettings;
    public static final String INTERNAL = "internal";
    public static final String USER = "user";

    public Settings getInternalSettings() throws SettingsException {
        if (this.internalSettings == null) {
            this.internalSettings = this.createSettings(INTERNAL);
        }
        return this.internalSettings;
    }

    public Settings getUserSettings() throws SettingsException {
        if (this.userSettings == null) {
            this.userSettings = this.createSettings(USER);
        }
        return this.userSettings;
    }

    public Settings createSettings(String key) throws SettingsException {
        return this.settingsFactory.createSettings(key);
    }

    public void setSettingsFactory(SettingsFactory factory) {
        this.settingsFactory = factory;
        if (this.settingsFactory == null) {
            this.settingsFactory = new TransientSettingsFactory();
        }
    }

    public SettingsFactory getSettingsFactory() {
        return this.settingsFactory;
    }

    public void exportSettings(Settings settings, OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void importSettings(Settings settings, InputStream in) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

