/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.j2seprefs;

import java.io.IOException;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.springframework.richclient.settings.AbstractSettings;
import org.springframework.richclient.settings.Settings;

public class PreferencesSettings
extends AbstractSettings {
    private Preferences prefs;

    public PreferencesSettings(String name) {
        this(null, name);
    }

    public PreferencesSettings(PreferencesSettings parent, String name) {
        super(parent, name);
        this.prefs = parent != null ? parent.getPreferences().node(name) : Preferences.userRoot().node(name);
    }

    public PreferencesSettings(Preferences preferences) {
        super(null, preferences.name());
        this.prefs = preferences;
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public void save() throws IOException {
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            IOException ioe = new IOException("Unable to save settings");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void load() throws IOException {
        try {
            this.prefs.sync();
        }
        catch (BackingStoreException e) {
            IOException ioe = new IOException("Unable to save settings");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected String internalGet(String key) {
        if (this.prefs.get(key, "").equals("")) {
            return null;
        }
        return this.prefs.get(key, "");
    }

    protected Settings internalCreateChild(String key) {
        return new PreferencesSettings(this, key);
    }

    protected void internalSet(String key, String value) {
        this.prefs.put(key, value);
    }

    public String[] getKeys() {
        try {
            return this.prefs.keys();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void internalRemove(String key) {
        this.prefs.remove(key);
    }

    public boolean internalContains(String key) {
        try {
            return Arrays.asList(this.prefs.keys()).contains(key);
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected String[] internalGetChildSettings() {
        try {
            return this.prefs.childrenNames();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void internalRemoveSettings() {
        try {
            this.prefs.removeNode();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }
}

