/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.j2seprefs;

import java.io.IOException;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import org.springframework.richclient.settings.Settings;
import org.springframework.richclient.settings.SettingsFactory;
import org.springframework.richclient.settings.j2seprefs.PreferencesSettings;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PreferencesSettingsFactory
implements SettingsFactory {
    private PreferencesFactory preferencesFactory;
    private String id;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PreferencesFactory getPreferencesFactory() {
        return this.preferencesFactory;
    }

    public void setPreferencesFactory(PreferencesFactory preferencesFactory) {
        this.preferencesFactory = preferencesFactory;
    }

    private Preferences getForId(Preferences root, String id) {
        Assert.notNull((Object)root);
        Preferences result = root;
        String[] idParts = id.split("\\.");
        for (int i = 0; i < idParts.length; ++i) {
            result = result.node(idParts[i]);
        }
        return result;
    }

    public Settings createSettings(String name) {
        Assert.state((boolean)StringUtils.hasText((String)this.id), (String)"An id must be assigned.");
        PreferencesSettings settings = null;
        settings = this.preferencesFactory == null ? new PreferencesSettings(this.getForId(Preferences.userRoot(), this.id).node(name)) : new PreferencesSettings(this.getForId(this.preferencesFactory.userRoot(), this.id).node(name));
        try {
            settings.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return settings;
    }
}

