/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.support;

import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.settings.Settings;
import org.springframework.richclient.settings.support.ArrayUtil;
import org.springframework.richclient.settings.support.Memento;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TableMemento
implements Memento {
    private static final Log logger = LogFactory.getLog((Class)TableMemento.class);
    private static final String COLUMN_WIDTHS = "columnWidths";
    private static final String COLUMN_ORDER = "columnOrder";
    private static final String SELECTED_ROWS = "selectedRows";
    private static final String ANCHOR = "anchor";
    private static final String LEAD = "lead";
    private JTable table;
    private String key;

    public TableMemento(JTable table, String key) {
        Assert.notNull((Object)table, (String)"Table cannot be null");
        Assert.isTrue((StringUtils.hasText((String)key) || StringUtils.hasText((String)table.getName()) ? 1 : 0) != 0, (String)"Key is empty or table has no name");
        if (!StringUtils.hasText((String)key)) {
            key = table.getName();
        }
        this.table = table;
        this.key = key;
    }

    public TableMemento(JTable table) {
        this(table, null);
    }

    public void saveState(Settings settings) {
        this.saveSelectedRows(settings);
        this.saveColumnOrder(settings);
        this.saveColumnWidths(settings);
    }

    void saveColumnWidths(Settings settings) {
        StringBuffer sb = new StringBuffer();
        int columnCount = this.table.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            sb.append(this.table.getColumnModel().getColumn(i).getWidth());
            if (i >= columnCount - 1) continue;
            sb.append(",");
        }
        settings.setString(this.key + "." + COLUMN_WIDTHS, sb.toString());
    }

    void saveColumnOrder(Settings settings) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.table.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            sb.append(column.getModelIndex());
            if (i >= this.table.getColumnModel().getColumnCount() - 1) continue;
            sb.append(",");
        }
        settings.setString(this.key + "." + COLUMN_ORDER, sb.toString());
    }

    void saveSelectedRows(Settings settings) {
        String selectionString;
        String settingsKey = this.key + "." + SELECTED_ROWS;
        if (settings.contains(settingsKey)) {
            settings.remove(settingsKey);
        }
        if (this.table.getSelectedRowCount() > 0) {
            settings.setInt(this.key + "." + ANCHOR, this.table.getSelectionModel().getAnchorSelectionIndex());
            settings.setInt(this.key + "." + LEAD, this.table.getSelectionModel().getLeadSelectionIndex());
        }
        if ((selectionString = ArrayUtil.asIntervalString(this.table.getSelectedRows())).length() > 0) {
            settings.setString(settingsKey, selectionString);
        }
    }

    public void restoreState(Settings settings) {
        this.restoreColumnOrder(settings);
        this.restoreColumnWidths(settings);
        this.restoreSelectedRows(settings);
    }

    void restoreColumnWidths(Settings settings) {
        this.table.getSelectionModel().clearSelection();
        String widthSetting = settings.getString(this.key + "." + COLUMN_WIDTHS);
        if (StringUtils.hasText((String)widthSetting)) {
            String[] stringWidths = widthSetting.split(",");
            try {
                int[] widths = ArrayUtil.toIntArray(stringWidths);
                if (widths.length == this.table.getColumnCount()) {
                    for (int i = 0; i < widths.length; ++i) {
                        this.table.getColumnModel().getColumn(i).setWidth(widths[i]);
                        this.table.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
                    }
                } else {
                    logger.warn((Object)("Unable to restore column widths, table has " + this.table.getColumnCount() + " columns, " + widths.length + " columns stored in settings"));
                }
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)"Unable to restore column widths", (Throwable)e);
            }
        }
    }

    void restoreSelectedRows(Settings settings) {
        String selection;
        this.table.getSelectionModel().clearSelection();
        if (settings.contains(this.key + "." + SELECTED_ROWS) && StringUtils.hasText((String)(selection = settings.getString(this.key + "." + SELECTED_ROWS)))) {
            String[] parts = selection.split(",");
            String lastPart = parts[parts.length - 1];
            int maxRow = -1;
            maxRow = lastPart.indexOf(45) >= 0 ? Integer.parseInt(lastPart.substring(lastPart.indexOf(45))) : Integer.parseInt(lastPart);
            if (maxRow <= this.table.getRowCount() - 1) {
                for (int i = 0; i < parts.length; ++i) {
                    if (parts[i].indexOf(45) >= 0) {
                        String[] tmp = parts[i].split("-");
                        this.table.addRowSelectionInterval(Integer.parseInt(tmp[0]), Integer.parseInt(tmp[1]));
                        continue;
                    }
                    int index = Integer.parseInt(parts[i]);
                    this.table.addRowSelectionInterval(index, index);
                }
            } else {
                logger.warn((Object)("Unable to restore row selection, table has " + this.table.getRowCount() + " rows, setting has max row " + maxRow));
            }
        }
        if (settings.contains(this.key + "." + ANCHOR)) {
            this.table.getSelectionModel().setAnchorSelectionIndex(settings.getInt(this.key + "." + ANCHOR));
        }
        if (settings.contains(this.key + "." + LEAD)) {
            this.table.getSelectionModel().setLeadSelectionIndex(settings.getInt(this.key + "." + LEAD));
        }
    }

    void restoreColumnOrder(Settings settings) {
        this.table.getSelectionModel().clearSelection();
        String orderSetting = settings.getString(this.key + "." + COLUMN_ORDER);
        if (StringUtils.hasText((String)orderSetting)) {
            String[] stringColumns = orderSetting.split(",");
            try {
                int[] columns = ArrayUtil.toIntArray(stringColumns);
                if (columns.length == this.table.getColumnCount()) {
                    for (int i = 0; i < columns.length; ++i) {
                        this.table.moveColumn(TableMemento.getPosition(this.table, columns[i]), i);
                    }
                } else {
                    logger.warn((Object)("Unable to restore column order, table has " + this.table.getColumnCount() + " columns, " + columns.length + " columns stored in settings"));
                }
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)"Unable to restore column order.", (Throwable)e);
            }
        }
    }

    private static int getPosition(JTable table, int modelIndex) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            if (column.getModelIndex() != modelIndex) continue;
            return i;
        }
        throw new IllegalArgumentException("No column with modelIndex " + modelIndex + " found");
    }

    protected String getKey() {
        return this.key;
    }

    public JTable getTable() {
        return this.table;
    }
}

