/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.support;

import java.awt.Frame;
import java.awt.Window;
import org.springframework.richclient.settings.Settings;
import org.springframework.richclient.settings.support.Memento;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class WindowMemento
implements Memento {
    private Window window;
    private String key;

    public WindowMemento(Window window) {
        this(window, null);
    }

    public WindowMemento(Window window, String key) {
        Assert.notNull((Object)window, (String)"Window cannot be null");
        Assert.isTrue((StringUtils.hasText((String)key) || StringUtils.hasText((String)window.getName()) ? 1 : 0) != 0, (String)"Key is empty or window has no name");
        if (!StringUtils.hasText((String)key)) {
            key = window.getName();
        }
        this.window = window;
        this.key = key;
    }

    public void saveState(Settings settings) {
        this.saveLocation(settings);
        this.saveSize(settings);
        this.saveMaximizedState(settings);
    }

    void saveMaximizedState(Settings settings) {
        if (this.window instanceof Frame) {
            Frame frame = (Frame)this.window;
            settings.setBoolean(this.key + ".maximized", frame.getExtendedState() == 6);
        }
    }

    void saveSize(Settings settings) {
        settings.setInt(this.key + ".height", this.window.getHeight());
        settings.setInt(this.key + ".width", this.window.getWidth());
    }

    void saveLocation(Settings settings) {
        settings.setInt(this.key + ".x", this.window.getX());
        settings.setInt(this.key + ".y", this.window.getY());
    }

    public void restoreState(Settings settings) {
        this.restoreLocation(settings);
        this.restoreSize(settings);
        this.restoreMaximizedState(settings);
    }

    void restoreMaximizedState(Settings settings) {
        if (this.window instanceof Frame) {
            Frame frame = (Frame)this.window;
            frame.setExtendedState(settings.getBoolean(this.key + ".maximized") ? 6 : 0);
        }
    }

    void restoreSize(Settings settings) {
        if (settings.contains(this.key + ".height") && settings.contains(this.key + ".width")) {
            this.window.setSize(settings.getInt(this.key + ".width"), settings.getInt(this.key + ".height"));
        }
    }

    void restoreLocation(Settings settings) {
        if (settings.contains(this.key + ".x") && settings.contains(this.key + ".y")) {
            this.window.setLocation(settings.getInt(this.key + ".x"), settings.getInt(this.key + ".y"));
        }
    }

    public Window getWindow() {
        return this.window;
    }

    public String getKey() {
        return this.key;
    }
}

