/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.richclient.settings.AbstractSettings;
import org.springframework.richclient.settings.Settings;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSettings
extends AbstractSettings {
    private Element element;
    private boolean entriesLoaded;
    private Map values = new HashMap();

    public XmlSettings(Settings parent, Element element) {
        super(parent, XmlSettings.getName(element));
        this.element = element;
    }

    public XmlSettings(Element element) {
        this(null, element);
    }

    private static String getName(Element element) {
        XmlSettings.verifyElement(element);
        return element.getAttribute("name");
    }

    private static void verifyElement(Element element) {
        Assert.notNull((Object)element, (String)"element cannot be null");
        Assert.isTrue((boolean)element.getNodeName().equals("settings"), (String)"element must be settings");
        Assert.isTrue((boolean)element.hasAttribute("name"), (String)"element must have name attribute");
    }

    protected Settings internalCreateChild(String key) {
        this.loadChildrenIfNecessary();
        Element childElement = null;
        NodeList childNodes = this.element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element tmp;
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !(tmp = (Element)node).getNodeName().equals("settings") || !tmp.getAttribute("name").equals(key)) continue;
            childElement = tmp;
        }
        if (childElement == null) {
            childElement = this.element.getOwnerDocument().createElement("settings");
            childElement.setAttribute("name", key);
            this.element.appendChild(childElement);
        }
        return new XmlSettings((Settings)this, childElement);
    }

    protected boolean internalContains(String key) {
        this.loadChildrenIfNecessary();
        return this.values.containsKey(key);
    }

    protected void internalSet(String key, String value) {
        this.loadChildrenIfNecessary();
        Element entry = this.findOrCreateEntry(key);
        entry.setAttribute("value", value);
        this.values.put(key, value);
    }

    private Element findEntry(String key) {
        NodeList childNodes = this.element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element tmp;
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("entry") || !(tmp = (Element)node).getAttribute("key").equals(key)) continue;
            return tmp;
        }
        return null;
    }

    private Element findOrCreateEntry(String key) {
        Element entry = this.findEntry(key);
        if (entry == null) {
            entry = this.element.getOwnerDocument().createElement("entry");
            entry.setAttribute("key", key);
            this.element.appendChild(entry);
        }
        return entry;
    }

    protected String internalGet(String key) {
        this.loadChildrenIfNecessary();
        return (String)this.values.get(key);
    }

    public String[] getKeys() {
        this.loadChildrenIfNecessary();
        return this.values.keySet().toArray(new String[this.values.size()]);
    }

    public void save() throws IOException {
        this.getParent().save();
    }

    private void loadChildrenIfNecessary() {
        if (!this.entriesLoaded) {
            NodeList childNodes = this.element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element el;
                Node node = childNodes.item(i);
                if (!(node instanceof Element) || !(el = (Element)node).getNodeName().equals("entry")) continue;
                this.values.put(el.getAttribute("key"), el.getAttribute("value"));
            }
            this.entriesLoaded = true;
        }
    }

    public void load() throws IOException {
        this.loadChildrenIfNecessary();
    }

    protected void internalRemove(String key) {
        this.loadChildrenIfNecessary();
        Element entry = this.findEntry(key);
        if (entry != null) {
            this.element.removeChild(entry);
        }
        this.values.remove(key);
    }

    public Element getElement() {
        return this.element;
    }

    protected String[] internalGetChildSettings() {
        ArrayList<String> childSettingsNames = new ArrayList<String>();
        NodeList childNodes = this.element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element el;
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !(el = (Element)node).getNodeName().equals("settings")) continue;
            childSettingsNames.add(el.getAttribute("name"));
        }
        return childSettingsNames.toArray(new String[childSettingsNames.size()]);
    }

    public void internalRemoveSettings() {
        this.element.getParentNode().removeChild(this.element);
    }
}

