/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table.support;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ResizeTableColumnSupport
implements TableCellRenderer,
TableModelListener {
    private static final int PADDING = 3;
    private int[] preferredWidths;
    private List registeredRenderers = new ArrayList();
    private JTable table;
    private ResizingMouseListener resizingMouseListener = new ResizingMouseListener();

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = this.getRenderer(column).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.preferredWidths[column] = Math.max(comp.getPreferredSize().width + 3, this.preferredWidths[column]);
        return comp;
    }

    private void resetWidths() {
        this.preferredWidths = new int[this.table.getColumnCount()];
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableCellRenderer headerRenderer = this.getColumn(i).getHeaderRenderer();
            if (headerRenderer == null) {
                headerRenderer = this.table.getTableHeader().getDefaultRenderer();
            }
            this.preferredWidths[i] = headerRenderer.getTableCellRendererComponent((JTable)this.table, (Object)this.table.getColumnName((int)i), (boolean)false, (boolean)false, (int)0, (int)i).getPreferredSize().width + 6;
        }
    }

    private TableColumn getColumn(int column) {
        return this.table.getColumnModel().getColumn(column);
    }

    private TableCellRenderer getRenderer(int column) {
        TableCellRenderer renderer = (TableCellRenderer)this.registeredRenderers.get(column);
        if (renderer == null) {
            renderer = this.table.getDefaultRenderer(this.table.getColumnClass(column));
        }
        return renderer;
    }

    public static void install(JTable table) {
        new ResizeTableColumnSupport(table);
    }

    private void initColumns() {
        this.registeredRenderers = new ArrayList(this.table.getColumnCount());
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.registeredRenderers.add(this.getColumn(i).getCellRenderer());
            this.getColumn(i).setCellRenderer(this);
        }
    }

    private void initialize() {
        this.initColumns();
        this.resetWidths();
        this.table.getModel().addTableModelListener(this);
    }

    public ResizeTableColumnSupport(JTable table) {
        this.table = table;
        this.initialize();
        table.addPropertyChangeListener("model", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TableModel oldModel = (TableModel)evt.getOldValue();
                if (oldModel != null) {
                    oldModel.removeTableModelListener(ResizeTableColumnSupport.this);
                }
                ResizeTableColumnSupport.this.initialize();
            }
        });
        table.getTableHeader().addMouseListener(this.resizingMouseListener);
    }

    public void tableChanged(TableModelEvent e) {
        this.resetWidths();
    }

    private class ResizingMouseListener
    extends MouseAdapter {
        private ResizingMouseListener() {
        }

        private TableColumn getResizingColumn(Point p) {
            return this.getResizingColumn(p, ResizeTableColumnSupport.this.table.getTableHeader().getColumnModel().getColumnIndexAtX(p.x));
        }

        private TableColumn getResizingColumn(Point p, int column) {
            int columnIndex;
            if (column == -1) {
                return null;
            }
            Rectangle r = ResizeTableColumnSupport.this.table.getTableHeader().getHeaderRect(column);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return null;
            }
            int midPoint = r.x + r.width / 2;
            int n = columnIndex = p.x < midPoint ? column - 1 : column;
            if (columnIndex == -1) {
                return null;
            }
            return ResizeTableColumnSupport.this.table.getTableHeader().getColumnModel().getColumn(columnIndex);
        }

        public void mouseClicked(MouseEvent e) {
            TableColumn column;
            if (e.getClickCount() == 2 && (column = this.getResizingColumn(e.getPoint())) != null) {
                e.consume();
                column.setPreferredWidth(ResizeTableColumnSupport.this.preferredWidths[ResizeTableColumnSupport.this.table.convertColumnIndexToView(column.getModelIndex())]);
            }
        }
    }
}

