/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.command.ActionCommand;

public class AdjustFontSizeCommand
extends ActionCommand {
    private double fontAdjustment = 1.0;

    public double getFontAdjustment() {
        return this.fontAdjustment;
    }

    public void setFontAdjustment(double fontAdjustment) {
        this.fontAdjustment = fontAdjustment;
    }

    protected void adjustFont(double adjustAmount) {
        System.out.println(Sizes.getUnitConverter().dialogUnitYAsPixel(10, (Component)new JLabel()));
        Object[] objs = UIManager.getLookAndFeel().getDefaults().keySet().toArray();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i].toString().toUpperCase().indexOf("FONT") == -1) continue;
            Font font = UIManager.getFont(objs[i]);
            UIManager.put(objs[i], new FontUIResource(font.deriveFont((float)((double)font.getSize() + adjustAmount))));
        }
        System.out.println(Sizes.getUnitConverter().dialogUnitYAsPixel(10, (Component)new JLabel()));
        ApplicationWindow[] applicationWindows = Application.instance().getWindowManager().getWindows();
        for (int i = 0; i < applicationWindows.length; ++i) {
            ApplicationWindow window = applicationWindows[i];
            SwingUtilities.updateComponentTreeUI(window.getControl());
            window.getControl().repaint();
        }
    }

    protected void doExecuteCommand() {
        Object fontAdjustmentParam = this.getParameter("fontAdjustment");
        double fontAdjustment = fontAdjustmentParam != null ? (fontAdjustmentParam instanceof Number ? ((Number)fontAdjustmentParam).doubleValue() : Double.parseDouble(fontAdjustmentParam.toString())) : this.getFontAdjustment();
        this.adjustFont(fontAdjustment);
    }
}

