/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint.property;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.binding.PropertyAccessStrategy;
import org.springframework.rules.constraint.property.AbstractPropertyConstraint;
import org.springframework.util.Assert;

public class PropertyInGroupConstraint
extends AbstractPropertyConstraint {
    public final String groupPropertyName;

    public PropertyInGroupConstraint(String propertyName, String groupPropertyName) {
        super(propertyName);
        Assert.notNull((Object)groupPropertyName, (String)"The groupPropertyName to constrain is required");
        this.groupPropertyName = groupPropertyName;
    }

    public boolean isDependentOn(String propertyName) {
        return super.isDependentOn(propertyName) || this.getGroupPropertyName().equals(propertyName);
    }

    public String getGroupPropertyName() {
        return this.groupPropertyName;
    }

    protected boolean test(PropertyAccessStrategy accessor) {
        Object propertyValue = accessor.getPropertyValue(this.getPropertyName());
        Collection values = this.getValues(accessor.getPropertyValue(this.getGroupPropertyName()));
        return values != null && values.contains(propertyValue);
    }

    private Collection getValues(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        throw new IllegalArgumentException("property " + this.getGroupPropertyName() + " must contain a collection or an object array");
    }
}

