/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import net.sf.nachocalendar.components.MoonPhase;

class MoonCanvas
extends Canvas {
    private Dimension d;
    private MoonPhase top;
    private int xmid;
    private int ymid;
    private double scale;

    public MoonCanvas(MoonPhase parent) {
        this.top = parent;
        this.scale = 0.5;
        this.setBackground(Color.black);
        this.setForeground(Color.white);
    }

    protected void paintSun(Graphics g) {
        int size = (int)((double)this.d.width * this.scale * this.top.sunsize / 2.0);
        g.setColor(Color.yellow);
        g.fillOval(this.xmid - size - (int)((double)this.d.width * this.scale * this.top.sundist), this.ymid - size, size * 2, size * 2);
    }

    protected void paintMoon(Graphics g) {
        int size = (int)((double)this.d.width * this.scale * this.top.moonsize / 2.0);
        g.setColor(Color.darkGray);
        g.fillOval(this.xmid - size + (int)((double)this.d.width * this.scale * this.top.moondist * Math.cos(this.top.phase * 2.0 * Math.PI)), this.ymid - size - (int)((double)this.d.width * this.scale * this.top.moondist * Math.sin(this.top.phase * 2.0 * Math.PI)), size * 2, size * 2);
        g.setColor(Color.white);
        g.fillArc(this.xmid - size + (int)((double)this.d.width * this.scale * this.top.moondist * Math.cos(this.top.phase * 2.0 * Math.PI)), this.ymid - size - (int)((double)this.d.width * this.scale * this.top.moondist * Math.sin(this.top.phase * 2.0 * Math.PI)), size * 2, size * 2, 90, 180);
    }

    protected void paintEarth(Graphics g) {
        int size = (int)((double)this.d.width * this.scale * this.top.earthsize / 2.0);
        g.setColor(Color.blue.darker());
        g.fillOval(this.xmid - size, this.ymid - size, size * 2, size * 2);
        g.setColor(Color.blue.brighter());
        g.fillArc(this.xmid - size, this.ymid - size, size * 2, size * 2, 90, 180);
    }

    protected void paintSky(Graphics g) {
        this.d = this.getSize();
        this.xmid = this.d.width / 2;
        this.ymid = this.d.height / 2;
        g.setColor(Color.black);
        g.fillRect(0, 0, this.d.width, this.d.height);
        if (this.top.both) {
            this.d.width /= 2;
            this.top.canvas2.paintSky(g, this.d.width, this.d.height, this.xmid + this.d.width / 2, this.ymid);
            g.setColor(Color.black);
            g.fillRect(0, 0, this.d.width, this.d.height);
            g.setColor(Color.red);
            g.drawLine(this.d.width, 0, this.d.width, this.d.height);
            this.xmid = this.d.width / 2;
        }
        this.xmid += this.d.width / 5;
        this.paintSun(g);
        this.paintMoon(g);
        this.paintEarth(g);
    }

    public void paint(Graphics g) {
        this.paintSky(this.top.gBuf);
        g.drawImage(this.top.buf, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public boolean mouseDown(Event evt, int x, int y) {
        return true;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        return true;
    }
}

