/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.Objects;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormatVariant;
import org.apache.jena.riot.RDFLanguages;

public class RDFFormat {
    public static final RDFFormatVariant PRETTY = new RDFFormatVariant("pretty");
    public static final RDFFormatVariant BLOCKS = new RDFFormatVariant("blocks");
    public static final RDFFormatVariant FLAT = new RDFFormatVariant("flat");
    public static final RDFFormatVariant ASCII = new RDFFormatVariant("ascii");
    public static final RDFFormatVariant UTF8 = new RDFFormatVariant("utf-8");
    public static final RDFFormatVariant ValueEncoding = new RDFFormatVariant("Value");
    public static final RDFFormat TURTLE_PRETTY;
    public static final RDFFormat TURTLE;
    public static final RDFFormat TTL;
    public static final RDFFormat TURTLE_BLOCKS;
    public static final RDFFormat TURTLE_FLAT;
    public static final RDFFormat NTRIPLES_UTF8;
    public static final RDFFormat NTRIPLES;
    public static final RDFFormat NT;
    public static final RDFFormat NTRIPLES_ASCII;
    public static final RDFFormat NQUADS_UTF8;
    public static final RDFFormat NQUADS;
    public static final RDFFormat NQ;
    public static final RDFFormat NQUADS_ASCII;
    public static final RDFFormat TRIG_PRETTY;
    public static final RDFFormat TRIG;
    public static final RDFFormat TRIG_BLOCKS;
    public static final RDFFormat TRIG_FLAT;
    public static final RDFFormat JSONLD_PRETTY;
    public static final RDFFormat JSONLD;
    public static final RDFFormat JSONLD_FLAT;
    public static final RDFFormatVariant ABBREV;
    public static final RDFFormatVariant PLAIN;
    public static final RDFFormat RDFXML_PRETTY;
    public static final RDFFormat RDFXML_ABBREV;
    public static final RDFFormat RDFXML;
    public static final RDFFormat RDFXML_PLAIN;
    public static final RDFFormat RDFJSON;
    public static final RDFFormat TRIX;
    public static final RDFFormat RDF_THRIFT;
    public static final RDFFormat RDF_THRIFT_VALUES;
    public static final RDFFormat RDFNULL;
    private final Lang lang;
    private final RDFFormatVariant variant;

    public RDFFormat(Lang lang) {
        this(lang, null);
    }

    public RDFFormat(Lang lang, RDFFormatVariant variant) {
        this.lang = lang;
        this.variant = variant;
    }

    public Lang getLang() {
        return this.lang;
    }

    public RDFFormatVariant getVariant() {
        return this.variant;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.variant == null ? 0 : this.variant.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RDFFormat other = (RDFFormat)obj;
        if (!Objects.equals(this.lang, other.lang)) {
            return false;
        }
        return Objects.equals(this.variant, other.variant);
    }

    public String toString() {
        if (this.variant == null) {
            return this.lang.getName();
        }
        return this.lang.getName() + "/" + this.variant;
    }

    static {
        TURTLE = TURTLE_PRETTY = new RDFFormat(Lang.TURTLE, PRETTY);
        TTL = TURTLE_PRETTY;
        TURTLE_BLOCKS = new RDFFormat(Lang.TURTLE, BLOCKS);
        TURTLE_FLAT = new RDFFormat(Lang.TURTLE, FLAT);
        NT = NTRIPLES = (NTRIPLES_UTF8 = new RDFFormat(Lang.NTRIPLES, UTF8));
        NTRIPLES_ASCII = new RDFFormat(Lang.NTRIPLES, ASCII);
        NQ = NQUADS = (NQUADS_UTF8 = new RDFFormat(Lang.NQUADS, UTF8));
        NQUADS_ASCII = new RDFFormat(Lang.NQUADS, ASCII);
        TRIG = TRIG_PRETTY = new RDFFormat(Lang.TRIG, PRETTY);
        TRIG_BLOCKS = new RDFFormat(Lang.TRIG, BLOCKS);
        TRIG_FLAT = new RDFFormat(Lang.TRIG, FLAT);
        JSONLD = JSONLD_PRETTY = new RDFFormat(Lang.JSONLD, PRETTY);
        JSONLD_FLAT = new RDFFormat(Lang.JSONLD, FLAT);
        ABBREV = new RDFFormatVariant("pretty");
        PLAIN = new RDFFormatVariant("plain");
        RDFXML_ABBREV = RDFXML_PRETTY = new RDFFormat(Lang.RDFXML, ABBREV);
        RDFXML = RDFXML_PRETTY;
        RDFXML_PLAIN = new RDFFormat(Lang.RDFXML, PLAIN);
        RDFJSON = new RDFFormat(Lang.RDFJSON);
        TRIX = new RDFFormat(Lang.TRIX);
        RDF_THRIFT = new RDFFormat(RDFLanguages.THRIFT);
        RDF_THRIFT_VALUES = new RDFFormat(RDFLanguages.THRIFT, ValueEncoding);
        RDFNULL = new RDFFormat(Lang.RDFNULL);
    }
}

