/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.slf4j.Logger;

public class ErrorHandlerFactory {
    public static final Logger stdLogger = SysRIOT.getLogger();
    public static final Logger noLogger = null;
    public static final ErrorHandler errorHandlerStd = ErrorHandlerFactory.errorHandlerStd(stdLogger);
    public static final ErrorHandler errorHandlerNoWarnings = ErrorHandlerFactory.errorHandlerNoWarnings(stdLogger);
    public static final ErrorHandler errorHandlerStrict = ErrorHandlerFactory.errorHandlerStrict(stdLogger);
    public static final ErrorHandler errorHandlerWarn = ErrorHandlerFactory.errorHandlerWarning(stdLogger);
    public static final ErrorHandler errorHandlerNoLogging = ErrorHandlerFactory.errorHandlerSimple();
    public static final ErrorHandler errorHandlerStrictNoLogging = ErrorHandlerFactory.errorHandlerStrictSilent();
    private static ErrorHandler defaultErrorHandler = errorHandlerStd;

    public static ErrorHandler errorHandlerStrictSilent() {
        return new ErrorHandlerStrict(null);
    }

    public static ErrorHandler errorHandlerStrict(Logger log2) {
        return new ErrorHandlerStrict(log2);
    }

    public static ErrorHandler errorHandlerStd(Logger log2) {
        return new ErrorHandlerStd(log2);
    }

    public static ErrorHandler errorHandlerNoWarnings(Logger log2) {
        return new ErrorHandlerNoWarnings(log2);
    }

    public static ErrorHandler errorHandlerWarning(Logger log2) {
        return new ErrorHandlerWarning(log2);
    }

    public static ErrorHandler errorHandlerSimple() {
        return new ErrorHandlerSimple();
    }

    public static ErrorHandler getDefaultErrorHandler() {
        return defaultErrorHandler;
    }

    public static void setDefaultErrorHandler(ErrorHandler errorHandler) {
        defaultErrorHandler = errorHandler;
    }

    private static class ErrorHandlerWarning
    extends ErrorLogger
    implements ErrorHandler {
        public ErrorHandlerWarning(Logger log2) {
            super(log2);
        }

        @Override
        public void warning(String message, long line, long col) {
            this.logWarning(message, line, col);
        }

        @Override
        public void error(String message, long line, long col) {
            this.logError(message, line, col);
        }

        @Override
        public void fatal(String message, long line, long col) {
            this.logFatal(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private static class ErrorHandlerStrictSilent
    implements ErrorHandler {
        private ErrorHandlerStrictSilent() {
        }

        @Override
        public void warning(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        @Override
        public void error(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        @Override
        public void fatal(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private static class ErrorHandlerStrict
    extends ErrorLogger
    implements ErrorHandler {
        public ErrorHandlerStrict(Logger log2) {
            super(log2);
        }

        @Override
        public void warning(String message, long line, long col) {
            this.logWarning(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        @Override
        public void error(String message, long line, long col) {
            this.logError(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        @Override
        public void fatal(String message, long line, long col) {
            this.logFatal(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private static class ErrorHandlerNoWarnings
    extends ErrorLogger
    implements ErrorHandler {
        public ErrorHandlerNoWarnings(Logger log2) {
            super(log2);
        }

        @Override
        public void warning(String message, long line, long col) {
        }

        @Override
        public void error(String message, long line, long col) {
            this.logError(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        @Override
        public void fatal(String message, long line, long col) {
            this.logFatal(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private static class ErrorHandlerStd
    extends ErrorLogger
    implements ErrorHandler {
        public ErrorHandlerStd(Logger log2) {
            super(log2);
        }

        @Override
        public void warning(String message, long line, long col) {
            this.logWarning(message, line, col);
        }

        @Override
        public void error(String message, long line, long col) {
            this.logError(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        @Override
        public void fatal(String message, long line, long col) {
            this.logFatal(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private static class ErrorHandlerSimple
    implements ErrorHandler {
        private ErrorHandlerSimple() {
        }

        @Override
        public void warning(String message, long line, long col) {
        }

        @Override
        public void error(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        @Override
        public void fatal(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private static class ErrorLogger {
        protected final Logger log;

        public ErrorLogger(Logger log2) {
            this.log = log2;
        }

        public void logWarning(String message, long line, long col) {
            if (this.log != null) {
                this.log.warn(SysRIOT.fmtMessage(message, line, col));
            }
        }

        public void logError(String message, long line, long col) {
            if (this.log != null) {
                this.log.error(SysRIOT.fmtMessage(message, line, col));
            }
        }

        public void logFatal(String message, long line, long col) {
            if (this.log != null) {
                this.logError(message, line, col);
            }
        }
    }
}

