/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction;

import java.util.Collection;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.Vars;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.PrintSerializableBase;

public class PropFuncArg
extends PrintSerializableBase {
    private List<Node> argList = null;
    private Node arg = null;

    public PropFuncArg(List<Node> argList, Node arg) {
        if (argList == null) {
            this.arg = arg;
            return;
        }
        this.argList = argList;
        if (argList.isEmpty()) {
            this.arg = NodeConst.nodeNil;
        }
    }

    public PropFuncArg(List<Node> argList) {
        this.argList = argList;
    }

    public PropFuncArg(Node arg) {
        this.arg = arg;
    }

    public Node getArg() {
        return this.arg;
    }

    public List<Node> getArgList() {
        return this.argList;
    }

    public int getArgListSize() {
        return this.argList == null ? -1 : this.argList.size();
    }

    public Node getArg(int index) {
        if (this.argList == null) {
            return null;
        }
        return this.argList.get(index);
    }

    public int hashCode() {
        if (this.isNode()) {
            return this.arg.hashCode();
        }
        return this.argList.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropFuncArg)) {
            return false;
        }
        PropFuncArg pfArg = (PropFuncArg)other;
        if (this.isNode()) {
            return this.arg.equals((Object)pfArg.arg);
        }
        return this.argList.equals(pfArg.argList);
    }

    public boolean isList() {
        return this.argList != null;
    }

    public boolean isNode() {
        return this.arg != null;
    }

    @Deprecated
    public ExprList asExprList(PropFuncArg pfArg) {
        ExprList exprList = new ExprList();
        if (pfArg.isNode()) {
            Node n = pfArg.getArg();
            Expr expr = ExprUtils.nodeToExpr(n);
            exprList.add(expr);
            return exprList;
        }
        for (Node n : pfArg.getArgList()) {
            Expr expr = ExprUtils.nodeToExpr(n);
            exprList.add(expr);
        }
        return exprList;
    }

    public ExprList asExprList() {
        ExprList exprList = new ExprList();
        if (this.isNode()) {
            Node n = this.getArg();
            Expr expr = ExprUtils.nodeToExpr(n);
            exprList.add(expr);
            return exprList;
        }
        for (Node n : this.getArgList()) {
            Expr expr = ExprUtils.nodeToExpr(n);
            exprList.add(expr);
        }
        return exprList;
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        if (this.argList == null && this.arg == null) {
            out.print("<<null>>");
        }
        if (this.argList != null) {
            out.print("(");
            boolean first = true;
            for (Node n : this.argList) {
                if (!first) {
                    out.print(" ");
                }
                String str2 = FmtUtils.stringForNode(n, sCxt);
                out.print(str2);
                first = false;
            }
            out.print(")");
        }
        if (this.arg != null) {
            out.print(FmtUtils.stringForNode(this.arg));
        }
    }

    public static void addVars(Collection<Var> acc, PropFuncArg pfArg) {
        if (pfArg.isNode()) {
            Vars.addVar(acc, pfArg.getArg());
            return;
        }
        for (Node n : pfArg.getArgList()) {
            Vars.addVar(acc, n);
        }
    }
}

