/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.NotUniqueException;
import org.apache.jena.sparql.util.PropertyRequiredException;
import org.apache.jena.sparql.util.QueryExecUtils;
import org.apache.jena.sparql.util.TypeNotUniqueException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public class GraphUtils {
    public static Iterator<Quad> triples2quadsDftGraph(Iterator<Triple> iter) {
        return GraphUtils.triples2quads(Quad.defaultGraphIRI, iter);
    }

    public static Iter<Quad> triples2quads(Node graphNode, Iterator<Triple> iter) {
        return Iter.iter(iter).map(t -> new Quad(graphNode, (Triple)t));
    }

    public static List<String> multiValueString(Resource r, Property p) {
        List<RDFNode> nodes = GraphUtils.multiValue(r, p);
        ArrayList<String> values = new ArrayList<String>();
        for (RDFNode n : nodes) {
            if (!n.isLiteral()) continue;
            values.add(((Literal)n).getString());
        }
        return values;
    }

    public static List<RDFNode> multiValue(Resource r, Property p) {
        ArrayList<RDFNode> values = new ArrayList<RDFNode>();
        StmtIterator sIter = r.listProperties(p);
        while (sIter.hasNext()) {
            Statement s = sIter.nextStatement();
            values.add(s.getObject());
        }
        return values;
    }

    public static List<Resource> multiValueResource(Resource r, Property p) {
        List<RDFNode> nodes = GraphUtils.multiValue(r, p);
        ArrayList<Resource> values = new ArrayList<Resource>();
        for (RDFNode n : nodes) {
            if (!n.isResource()) continue;
            values.add((Resource)n);
        }
        return values;
    }

    public static List<String> multiValueURI(Resource r, Property p) {
        List<RDFNode> nodes = GraphUtils.multiValue(r, p);
        ArrayList<String> values = new ArrayList<String>();
        for (RDFNode n : nodes) {
            if (!n.isURIResource()) continue;
            values.add(((Resource)n).getURI());
        }
        return values;
    }

    public static boolean exactlyOneProperty(Resource r, Property p) {
        try (StmtIterator sIter = r.listProperties(p);){
            if (!sIter.hasNext()) {
                throw new PropertyRequiredException(r, p);
            }
            sIter.next();
            if (sIter.hasNext()) {
                throw new NotUniqueException(r, p);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean atmostOneProperty(Resource r, Property p) {
        try (StmtIterator sIter = r.listProperties(p);){
            if (!sIter.hasNext()) {
                boolean bl = true;
                return bl;
            }
            sIter.next();
            if (sIter.hasNext()) {
                throw new NotUniqueException(r, p);
            }
        }
        return true;
    }

    public static String getStringValue(Resource r, Property p) {
        if (!GraphUtils.atmostOneProperty(r, p)) {
            throw new NotUniqueException(r, p);
        }
        Statement s = r.getProperty(p);
        if (s == null) {
            return null;
        }
        return s.getString();
    }

    public static String getAsStringValue(Resource r, Property p) {
        if (!GraphUtils.atmostOneProperty(r, p)) {
            throw new NotUniqueException(r, p);
        }
        Statement s = r.getProperty(p);
        if (s == null) {
            return null;
        }
        if (s.getObject().isResource()) {
            return s.getResource().getURI();
        }
        return s.getString();
    }

    public static Resource getResourceValue(Resource r, Property p) {
        if (!GraphUtils.atmostOneProperty(r, p)) {
            throw new NotUniqueException(r, p);
        }
        Statement s = r.getProperty(p);
        if (s == null) {
            return null;
        }
        return s.getResource();
    }

    public static Resource getResourceByType(Model model, Resource type) {
        StmtIterator sIter = model.listStatements(null, RDF.type, (RDFNode)type);
        if (!sIter.hasNext()) {
            return null;
        }
        Resource r = sIter.nextStatement().getSubject();
        if (sIter.hasNext()) {
            throw new TypeNotUniqueException(r);
        }
        return r;
    }

    public static Resource findRootByType(Model model, Resource atype) {
        String s = StrUtils.strjoin((String)"\n", (String[])new String[]{"PREFIX  rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX  rdfs:   <http://www.w3.org/2000/01/rdf-schema#>", "SELECT DISTINCT ?root { { ?root rdf:type ?ATYPE } UNION { ?root rdf:type ?t . ?t rdfs:subClassOf ?ATYPE } }"});
        Query q = QueryFactory.create(s);
        QuerySolutionMap qsm = new QuerySolutionMap();
        qsm.add("ATYPE", (RDFNode)atype);
        QueryExecution qExec = QueryExecutionFactory.create(q, model, (QuerySolution)qsm);
        Resource r = (Resource)QueryExecUtils.getOne(qExec, "root");
        return r;
    }

    public static String fmtURI(Resource r) {
        return r.getModel().shortForm(r.getURI());
    }

    public static Iterator<Node> allNodes(Graph graph) {
        HashSet<Node> x = new HashSet<Node>(1000);
        ExtendedIterator iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            x.add(t.getSubject());
            x.add(t.getObject());
        }
        iter.close();
        return x.iterator();
    }
}

