/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.util.intern.duplex;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlbeam.util.intern.DOMHelper;
import org.xmlbeam.util.intern.duplex.BuildDocumentVisitor;
import org.xmlbeam.util.intern.duplex.ExpressionType;
import org.xmlbeam.util.intern.duplex.ExpressionTypeEvaluationVisitor;
import org.xmlbeam.util.intern.duplex.INodeEvaluationVisitor;
import org.xmlbeam.util.intern.duplex.SimpleNode;

public class DuplexExpression {
    private static final SimpleNode.StepListFilter ALL_BUT_LAST = new SimpleNode.StepListFilter(){

        @Override
        public List<SimpleNode> filter(SimpleNode[] children) {
            if (children.length < 2) {
                return Collections.emptyList();
            }
            List<SimpleNode> list = Arrays.asList(children).subList(0, children.length - 1);
            assert (list.size() == children.length - 1);
            return list;
        }
    };
    private static final SimpleNode.StepListFilter ONLY_LAST_STEP = new SimpleNode.StepListFilter(){

        @Override
        public List<SimpleNode> filter(SimpleNode[] children) {
            if (children.length < 1) {
                return Collections.emptyList();
            }
            assert (children[children.length - 1] != null);
            return Collections.singletonList(children[children.length - 1]);
        }
    };
    private XPathVariableResolver variableResolver = null;
    private final SimpleNode node;
    private final String xpath;
    private final Map<String, String> variableFormatPatterns = new HashMap<String, String>();
    private final String strippedXPath;
    private final String expressionFormatPattern;
    private final Map<String, String> userDefinedMapping;

    public DuplexExpression setXPathVariableResolver(XPathVariableResolver resolver) {
        this.variableResolver = resolver;
        return this;
    }

    public String toString() {
        return "DuplexExpression [xpath=" + this.xpath + "]";
    }

    DuplexExpression(SimpleNode node, String xpath, Map<String, String> userDefinedMapping) {
        this.node = node;
        this.xpath = xpath;
        this.userDefinedMapping = userDefinedMapping;
        final LinkedList<Integer> removeStartPositions = new LinkedList<Integer>();
        final LinkedList<Integer> removeEndPositions = new LinkedList<Integer>();
        node.getFirstChildWithId(1).eachChild(new INodeEvaluationVisitor.VisitorClosure(){

            @Override
            public void apply(SimpleNode node, Node data) {
                if (node.getID() != 52) {
                    return;
                }
                SimpleNode qnameNode = node.getFirstChildWithId(88);
                if (qnameNode == null) {
                    return;
                }
                SimpleNode formatNode = node.getFirstChildWithId(51);
                if (formatNode == null) {
                    DuplexExpression.this.variableFormatPatterns.put(qnameNode.getValue(), null);
                    return;
                }
                DuplexExpression.this.variableFormatPatterns.put(qnameNode.getValue(), DuplexExpression.this.stripFormatMarkers(formatNode.getValue()));
                removeStartPositions.push(formatNode.getStartColumn());
                removeEndPositions.push(formatNode.getEndColumn());
            }
        }, null);
        SimpleNode formatPatternNode = node.getFirstChildWithId(2);
        if (formatPatternNode != null) {
            this.expressionFormatPattern = formatPatternNode.getValue();
            removeStartPositions.push(formatPatternNode.getStartColumn());
            removeEndPositions.push(formatPatternNode.getEndColumn());
        } else {
            formatPatternNode = node.getFirstChildWithId(51);
            if (formatPatternNode != null) {
                this.expressionFormatPattern = this.stripFormatMarkers(formatPatternNode.getValue());
                removeStartPositions.push(formatPatternNode.getStartColumn());
                removeEndPositions.push(formatPatternNode.getEndColumn());
            } else {
                this.expressionFormatPattern = null;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(xpath);
        while (!removeEndPositions.isEmpty()) {
            stringBuilder.delete((Integer)removeStartPositions.pop(), (Integer)removeEndPositions.pop() + 1);
        }
        this.strippedXPath = stringBuilder.toString();
    }

    public boolean isUsingVariables() {
        return !this.variableFormatPatterns.keySet().isEmpty();
    }

    private String stripFormatMarkers(String value) {
        return (value = value.substring(2, value.length() - 2)).startsWith("using ") ? value.substring("using ".length()) : value;
    }

    public ExpressionType getExpressionType() {
        try {
            ExpressionType expressionType = this.node.firstChildAccept(new ExpressionTypeEvaluationVisitor(), null);
            return expressionType;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Please report this bug: Can not determine type of XPath:" + this.xpath, e);
        }
    }

    public Node ensureExistence(Node contextNode) {
        Document document = DOMHelper.getOwnerDocumentFor(contextNode);
        HashMap<String, String> namespaceMapping = new HashMap<String, String>(this.userDefinedMapping);
        namespaceMapping.putAll(DOMHelper.getNamespaceMapping(document));
        return (Node)((List)this.node.firstChildAccept(new BuildDocumentVisitor(this.variableResolver, namespaceMapping), contextNode)).get(0);
    }

    public Element ensureParentExistence(Node contextNode) {
        Document document = DOMHelper.getOwnerDocumentFor(contextNode);
        HashMap<String, String> namespaceMapping = new HashMap<String, String>(this.userDefinedMapping);
        namespaceMapping.putAll(DOMHelper.getNamespaceMapping(document));
        return (Element)((List)this.node.firstChildAccept(new BuildDocumentVisitor(this.variableResolver, namespaceMapping, ALL_BUT_LAST, BuildDocumentVisitor.MODE.CREATE_IF_NOT_EXISTS), contextNode)).get(0);
    }

    public void deleteAllMatchingChildren(Node parentNode) {
        List result;
        Document document = DOMHelper.getOwnerDocumentFor(parentNode);
        Map<String, String> namespaceMapping = DOMHelper.getNamespaceMapping(document);
        BuildDocumentVisitor visitor = new BuildDocumentVisitor(this.variableResolver, namespaceMapping, ONLY_LAST_STEP, BuildDocumentVisitor.MODE.DELETE);
        int lastLength = -1;
        do {
            if ((result = (List)this.node.firstChildAccept(visitor, parentNode)).size() == lastLength) {
                throw new IllegalStateException("Infinite loop detected. Please report issue with example.");
            }
            lastLength = result.size();
        } while (!result.isEmpty() && null != result.get(0));
    }

    public Node createChildWithPredicate(Node parentNode) {
        Document document = DOMHelper.getOwnerDocumentFor(parentNode);
        HashMap<String, String> namespaceMapping = new HashMap<String, String>(this.userDefinedMapping);
        namespaceMapping.putAll(DOMHelper.getNamespaceMapping(document));
        BuildDocumentVisitor visitor = new BuildDocumentVisitor(this.variableResolver, namespaceMapping, ONLY_LAST_STEP, BuildDocumentVisitor.MODE.JUST_CREATE);
        List nodes = (List)this.node.firstChildAccept(visitor, parentNode);
        assert (nodes.size() == 1);
        return (Node)nodes.get(0);
    }

    public void dump() {
        this.node.dump("");
    }

    public String getExpressionFormatPattern() {
        return this.expressionFormatPattern;
    }

    public String getExpressionAsStringWithoutFormatPatterns() {
        return this.strippedXPath;
    }

    public String getVariableFormatPattern(String name) {
        return this.variableFormatPatterns.get(name);
    }

    public boolean hasExpressionFormatPattern() {
        return this.expressionFormatPattern != null;
    }
}

