/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.form.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.binding.MutablePropertyAccessStrategy;
import org.springframework.binding.PropertyAccessStrategy;
import org.springframework.binding.PropertyMetadataAccessStrategy;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.Converter;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.binding.convert.support.GenericConversionService;
import org.springframework.binding.form.CommitListener;
import org.springframework.binding.form.ConfigurableFormModel;
import org.springframework.binding.form.FieldFace;
import org.springframework.binding.form.FieldFaceSource;
import org.springframework.binding.form.FieldMetadata;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.HierarchicalFormModel;
import org.springframework.binding.form.support.DefaultFieldMetadata;
import org.springframework.binding.form.support.FormModelMediatingValueModel;
import org.springframework.binding.form.support.FormModelPropertyAccessStrategy;
import org.springframework.binding.support.BeanPropertyAccessStrategy;
import org.springframework.binding.value.CommitTrigger;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractPropertyChangePublisher;
import org.springframework.binding.value.support.BufferedValueModel;
import org.springframework.binding.value.support.DirtyTrackingValueModel;
import org.springframework.binding.value.support.MethodInvokingDerivedValueModel;
import org.springframework.binding.value.support.TypeConverter;
import org.springframework.binding.value.support.ValueHolder;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.util.Assert;
import org.springframework.richclient.util.ClassUtils;
import org.springframework.richclient.util.EventListenerListHelper;
import org.springframework.util.CachingMapDecorator;

public abstract class AbstractFormModel
extends AbstractPropertyChangePublisher
implements HierarchicalFormModel,
ConfigurableFormModel {
    private String id;
    private final FormModelMediatingValueModel formObjectHolder;
    private final MutablePropertyAccessStrategy propertyAccessStrategy;
    private HierarchicalFormModel parent;
    private final List children = new ArrayList();
    private boolean buffered = false;
    private boolean enabled = true;
    private boolean oldEnabled = true;
    private boolean readOnly = false;
    private boolean oldReadOnly = false;
    private boolean oldDirty;
    private boolean oldCommittable = true;
    private ConversionService conversionService;
    private final CommitTrigger commitTrigger = new CommitTrigger();
    private final Map mediatingValueModels = new HashMap();
    private final Map propertyValueModels = new HashMap();
    private final Map convertingValueModels = new HashMap();
    private final Map fieldMetadata = new HashMap();
    private final Set dirtyValueAndFormModels = new HashSet();
    private final Map propertyConversionServices = new CachingMapDecorator(){

        public Object create(Object key) {
            return new DefaultConversionService(){

                protected void addDefaultConverters() {
                }
            };
        }
    };
    private FieldFaceSource fieldFaceSource;
    protected final PropertyChangeListener parentStateChangeHandler = new ParentStateChangeHandler();
    protected final PropertyChangeListener childStateChangeHandler = new ChildStateChangeHandler();
    private final EventListenerListHelper commitListeners = new EventListenerListHelper(CommitListener.class);
    private Class defaultInstanceClass;

    protected AbstractFormModel() {
        this(new ValueHolder());
    }

    protected AbstractFormModel(Object domainObject) {
        this((ValueModel)new ValueHolder(domainObject), true);
    }

    public AbstractFormModel(Object domainObject, boolean buffered) {
        this((ValueModel)new ValueHolder(domainObject), buffered);
    }

    protected AbstractFormModel(ValueModel formObjectHolder, boolean buffered) {
        this.prepareValueModel(formObjectHolder);
        this.formObjectHolder = new FormModelMediatingValueModel(formObjectHolder, false);
        this.propertyAccessStrategy = new BeanPropertyAccessStrategy(formObjectHolder);
        this.buffered = buffered;
        this.defaultInstanceClass = formObjectHolder.getValue().getClass();
    }

    protected AbstractFormModel(MutablePropertyAccessStrategy propertyAccessStrategy, boolean buffered) {
        this.formObjectHolder = new FormModelMediatingValueModel(propertyAccessStrategy.getDomainObjectHolder(), false);
        this.propertyAccessStrategy = propertyAccessStrategy;
        this.buffered = buffered;
    }

    protected void prepareValueModel(ValueModel valueModel) {
        if (valueModel instanceof BufferedValueModel) {
            ((BufferedValueModel)valueModel).setCommitTrigger(this.commitTrigger);
        }
        if (valueModel instanceof DirtyTrackingValueModel) {
            ((DirtyTrackingValueModel)valueModel).addPropertyChangeListener("dirty", this.childStateChangeHandler);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getFormObject() {
        return this.getFormObjectHolder().getValue();
    }

    public void setFormObject(Object formObject) {
        this.setDeliverValueChangeEvents(false, false);
        if (formObject == null) {
            this.handleSetNullFormObject();
        } else {
            this.getFormObjectHolder().setValue(formObject);
            this.setEnabled(true);
        }
        this.commitTrigger.revert();
        this.setDeliverValueChangeEvents(true, true);
    }

    private void setDeliverValueChangeEvents(boolean deliverValueChangeEvents, boolean clearValueModels) {
        this.formObjectHolder.setDeliverValueChangeEvents(deliverValueChangeEvents);
        Iterator i = this.mediatingValueModels.values().iterator();
        while (i.hasNext()) {
            FormModelMediatingValueModel valueModel = (FormModelMediatingValueModel)i.next();
            valueModel.setDeliverValueChangeEvents(deliverValueChangeEvents);
            if (!clearValueModels) continue;
            valueModel.clearDirty();
        }
    }

    public void setDefaultInstanceClass(Class defaultInstanceClass) {
        this.defaultInstanceClass = defaultInstanceClass;
    }

    public Class getDefaultInstanceClass() {
        return this.defaultInstanceClass;
    }

    protected void handleSetNullFormObject() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"New form object value is null; resetting to a new fresh object instance and disabling form");
        }
        if (this.getDefaultInstanceClass() != null) {
            this.getFormObjectHolder().setValue(BeanUtils.instantiateClass((Class)this.getDefaultInstanceClass()));
        } else {
            this.getFormObjectHolder().setValue(BeanUtils.instantiateClass(this.getFormObject().getClass()));
        }
        this.setEnabled(false);
    }

    public ValueModel getFormObjectHolder() {
        return this.formObjectHolder;
    }

    public HierarchicalFormModel getParent() {
        return this.parent;
    }

    public void setParent(HierarchicalFormModel parent) {
        Assert.required((Object)parent, (String)"parent");
        this.parent = parent;
        this.parent.addPropertyChangeListener("enabled", this.parentStateChangeHandler);
        this.parent.addPropertyChangeListener("readOnly", this.parentStateChangeHandler);
    }

    public void removeParent() {
        this.parent.removePropertyChangeListener("readOnly", this.parentStateChangeHandler);
        this.parent.removePropertyChangeListener("enabled", this.parentStateChangeHandler);
        this.parent = null;
    }

    public FormModel[] getChildren() {
        return this.children.toArray(new FormModel[this.children.size()]);
    }

    public void addChild(HierarchicalFormModel child) {
        Assert.required((Object)child, (String)"child");
        if (child.getParent() == this) {
            return;
        }
        Assert.isTrue((child.getParent() == null ? 1 : 0) != 0, (String)("Child form model '" + child + "' already has a parent"));
        child.setParent((HierarchicalFormModel)this);
        this.children.add(child);
        child.addPropertyChangeListener("dirty", this.childStateChangeHandler);
        child.addPropertyChangeListener("committable", this.childStateChangeHandler);
    }

    public void removeChild(HierarchicalFormModel child) {
        Assert.required((Object)child, (String)"child");
        child.removeParent();
        this.children.remove(child);
        child.removePropertyChangeListener("dirty", this.childStateChangeHandler);
        child.removePropertyChangeListener("committable", this.childStateChangeHandler);
        if (this.dirtyValueAndFormModels.remove(child)) {
            this.dirtyUpdated();
        }
    }

    public boolean hasValueModel(String formProperty) {
        return this.propertyValueModels.containsKey(formProperty);
    }

    public ValueModel getValueModel(String formProperty) {
        ValueModel propertyValueModel = (ValueModel)this.propertyValueModels.get(formProperty);
        if (propertyValueModel == null) {
            propertyValueModel = this.add(formProperty);
        }
        return propertyValueModel;
    }

    public ValueModel getValueModel(String formProperty, Class targetClass) {
        ConvertingValueModelKey key = new ConvertingValueModelKey(formProperty, targetClass);
        ValueModel convertingValueModel = (ValueModel)this.convertingValueModels.get(key);
        if (convertingValueModel == null) {
            convertingValueModel = this.createConvertingValueModel(formProperty, targetClass);
            this.convertingValueModels.put(key, convertingValueModel);
        }
        return convertingValueModel;
    }

    protected ValueModel createValueModel(String formProperty) {
        Assert.required((Object)formProperty, (String)"formProperty");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating " + (this.buffered ? "buffered" : "") + " value model for form property '" + formProperty + "'."));
        }
        return this.buffered ? new BufferedValueModel(this.propertyAccessStrategy.getPropertyValueModel(formProperty)) : this.propertyAccessStrategy.getPropertyValueModel(formProperty);
    }

    protected ValueModel createConvertingValueModel(String formProperty, Class targetClass) {
        GenericConversionService propertyConversionService;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating converting value model for form property '" + formProperty + "' converting to type '" + targetClass + "'."));
        }
        ValueModel sourceValueModel = this.getValueModel(formProperty);
        Assert.notNull((Object)sourceValueModel, (String)("Form does not have a property called '" + formProperty + "'."));
        Class sourceClass = ClassUtils.convertPrimitiveToWrapper((Class)this.getFieldMetadata(formProperty).getPropertyType());
        if (sourceClass == null || sourceClass == targetClass) {
            return sourceValueModel;
        }
        ConversionService conversionService = this.getConversionService();
        ConversionExecutor convertTo = null;
        ConversionExecutor convertFrom = null;
        if (this.propertyConversionServices.containsKey(formProperty) && (propertyConversionService = (GenericConversionService)this.propertyConversionServices.get(formProperty)) != null) {
            convertTo = propertyConversionService.getConversionExecutor(sourceClass, targetClass);
            convertFrom = propertyConversionService.getConversionExecutor(targetClass, sourceClass);
        }
        if (convertTo == null) {
            convertTo = conversionService.getConversionExecutor(sourceClass, targetClass);
        }
        Assert.notNull(convertTo, (String)"conversionService returned null ConversionExecutor");
        if (convertFrom == null) {
            convertFrom = conversionService.getConversionExecutor(targetClass, sourceClass);
        }
        Assert.notNull(convertFrom, (String)"conversionService returned null ConversionExecutor");
        ValueModel convertingValueModel = this.preProcessNewConvertingValueModel(formProperty, targetClass, (ValueModel)new TypeConverter(sourceValueModel, convertTo, convertFrom));
        this.preProcessNewConvertingValueModel(formProperty, targetClass, convertingValueModel);
        return convertingValueModel;
    }

    public void registerPropertyConverter(String propertyName, Converter toConverter, Converter fromConverter) {
        DefaultConversionService propertyConversionService = (DefaultConversionService)this.propertyConversionServices.get(propertyName);
        propertyConversionService.addConverter(toConverter);
        propertyConversionService.addConverter(fromConverter);
    }

    public ValueModel add(String propertyName) {
        return this.add(propertyName, this.createValueModel(propertyName));
    }

    public ValueModel add(String formProperty, ValueModel valueModel) {
        if (valueModel instanceof BufferedValueModel) {
            ((BufferedValueModel)valueModel).setCommitTrigger(this.commitTrigger);
        }
        PropertyMetadataAccessStrategy metadataAccessStrategy = this.getFormObjectPropertyAccessStrategy().getMetadataAccessStrategy();
        FormModelMediatingValueModel mediatingValueModel = new FormModelMediatingValueModel(valueModel, metadataAccessStrategy.isWriteable(formProperty));
        this.mediatingValueModels.put(formProperty, mediatingValueModel);
        DefaultFieldMetadata metadata = new DefaultFieldMetadata((FormModel)this, mediatingValueModel, metadataAccessStrategy.getPropertyType(formProperty), !metadataAccessStrategy.isWriteable(formProperty), metadataAccessStrategy.getAllUserMetadata(formProperty));
        metadata.addPropertyChangeListener("dirty", this.childStateChangeHandler);
        return this.add(formProperty, (ValueModel)mediatingValueModel, metadata);
    }

    public ValueModel add(String propertyName, ValueModel valueModel, FieldMetadata metadata) {
        this.fieldMetadata.put(propertyName, metadata);
        valueModel = this.preProcessNewValueModel(propertyName, valueModel);
        this.propertyValueModels.put(propertyName, valueModel);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering '" + propertyName + "' form property, property value model=" + valueModel));
        }
        this.postProcessNewValueModel(propertyName, valueModel);
        return valueModel;
    }

    protected abstract ValueModel preProcessNewValueModel(String var1, ValueModel var2);

    protected abstract void postProcessNewValueModel(String var1, ValueModel var2);

    protected abstract ValueModel preProcessNewConvertingValueModel(String var1, Class var2, ValueModel var3);

    protected abstract void postProcessNewConvertingValueModel(String var1, Class var2, ValueModel var3);

    public FieldMetadata getFieldMetadata(String propertyName) {
        FieldMetadata metadata = (FieldMetadata)this.fieldMetadata.get(propertyName);
        if (metadata == null) {
            this.add(propertyName);
            metadata = (FieldMetadata)this.fieldMetadata.get(propertyName);
        }
        return metadata;
    }

    public Set getFieldNames() {
        return Collections.unmodifiableSet(this.propertyValueModels.keySet());
    }

    public void setFieldFaceSource(FieldFaceSource fieldFaceSource) {
        this.fieldFaceSource = fieldFaceSource;
    }

    protected FieldFaceSource getFieldFaceSource() {
        if (this.fieldFaceSource == null) {
            this.fieldFaceSource = (FieldFaceSource)ApplicationServicesLocator.services().getService(FieldFaceSource.class);
        }
        return this.fieldFaceSource;
    }

    public FieldFace getFieldFace(String field) {
        return this.getFieldFaceSource().getFieldFace(field, (Object)this);
    }

    public ValueModel addMethod(String propertyMethodName, String derivedFromProperty) {
        return this.addMethod(propertyMethodName, new String[]{derivedFromProperty});
    }

    public ValueModel addMethod(String propertyMethodName, String[] derivedFromProperties) {
        ValueModel[] propertyValueModels = new ValueModel[derivedFromProperties.length];
        for (int i = 0; i < propertyValueModels.length; ++i) {
            propertyValueModels[i] = this.getValueModel(derivedFromProperties[i]);
        }
        MethodInvokingDerivedValueModel valueModel = new MethodInvokingDerivedValueModel((Object)this, propertyMethodName, propertyValueModels);
        return this.add(propertyMethodName, (ValueModel)valueModel);
    }

    public ConversionService getConversionService() {
        if (this.conversionService == null) {
            this.conversionService = (ConversionService)ApplicationServicesLocator.services().getService(ConversionService.class);
        }
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public MutablePropertyAccessStrategy getFormObjectPropertyAccessStrategy() {
        return this.propertyAccessStrategy;
    }

    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return new FormModelPropertyAccessStrategy((FormModel)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Commit requested for this form model " + (Object)((Object)this)));
        }
        if (this.getFormObject() == null) {
            if (!this.logger.isDebugEnabled()) return;
            this.logger.debug((Object)"Form object is null; nothing to commit.");
            return;
        }
        if (!this.isCommittable()) throw new IllegalStateException("Form model '" + (Object)((Object)this) + "' is not committable");
        Iterator i = this.commitListeners.iterator();
        while (i.hasNext()) {
            ((CommitListener)i.next()).preCommit((FormModel)this);
        }
        this.preCommit();
        if (!this.isCommittable()) throw new IllegalStateException("Form model '" + (Object)((Object)this) + "' became non-committable after preCommit phase");
        this.doCommit();
        this.postCommit();
        i = this.commitListeners.iterator();
        while (i.hasNext()) {
            ((CommitListener)i.next()).postCommit((FormModel)this);
        }
    }

    private void doCommit() {
        Iterator<Object> i = this.children.iterator();
        while (i.hasNext()) {
            ((FormModel)i.next()).commit();
        }
        this.commitTrigger.commit();
        i = this.mediatingValueModels.values().iterator();
        while (i.hasNext()) {
            ((DirtyTrackingValueModel)i.next()).clearDirty();
        }
    }

    protected void preCommit() {
    }

    protected void postCommit() {
    }

    public void revert() {
        Iterator<Object> i = this.children.iterator();
        while (i.hasNext()) {
            ((FormModel)i.next()).revert();
        }
        this.commitTrigger.revert();
        i = this.mediatingValueModels.values().iterator();
        while (i.hasNext()) {
            ((DirtyTrackingValueModel)i.next()).revertToOriginal();
        }
    }

    public void reset() {
        this.setFormObject(null);
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public boolean isDirty() {
        return this.dirtyValueAndFormModels.size() > 0;
    }

    protected void dirtyUpdated() {
        boolean dirty = this.isDirty();
        if (this.hasChanged(this.oldDirty, dirty)) {
            this.oldDirty = dirty;
            this.firePropertyChange("dirty", !dirty, dirty);
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.readOnlyUpdated();
    }

    public boolean isReadOnly() {
        return this.readOnly || this.parent != null && this.parent.isReadOnly();
    }

    protected void readOnlyUpdated() {
        boolean localReadOnly = this.isReadOnly();
        if (this.hasChanged(this.oldReadOnly, localReadOnly)) {
            this.oldReadOnly = localReadOnly;
            this.firePropertyChange("readOnly", !localReadOnly, localReadOnly);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.enabledUpdated();
    }

    public boolean isEnabled() {
        return this.enabled && (this.parent == null || this.parent.isEnabled());
    }

    protected void enabledUpdated() {
        boolean enabled = this.isEnabled();
        if (this.hasChanged(this.oldEnabled, enabled)) {
            this.oldEnabled = enabled;
            this.firePropertyChange("enabled", !enabled, enabled);
        }
    }

    public boolean isCommittable() {
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            FormModel childFormModel = (FormModel)i.next();
            if (childFormModel.isCommittable()) continue;
            return false;
        }
        return true;
    }

    protected void committableUpdated() {
        boolean committable = this.isCommittable();
        if (this.hasChanged(this.oldCommittable, committable)) {
            this.oldCommittable = committable;
            this.firePropertyChange("committable", !committable, committable);
        }
    }

    public void addCommitListener(CommitListener listener) {
        this.commitListeners.add((Object)listener);
    }

    public void removeCommitListener(CommitListener listener) {
        this.commitListeners.remove((Object)listener);
    }

    protected void parentStateChanged(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            this.enabledUpdated();
        } else if ("readOnly".equals(evt.getPropertyName())) {
            this.readOnlyUpdated();
        }
    }

    protected void childStateChanged(PropertyChangeEvent evt) {
        if ("dirty".equals(evt.getPropertyName())) {
            Object source = evt.getSource();
            if (source instanceof FieldMetadata) {
                FieldMetadata metadata = (FieldMetadata)source;
                if (metadata.isDirty()) {
                    this.dirtyValueAndFormModels.add(metadata);
                } else {
                    this.dirtyValueAndFormModels.remove(metadata);
                }
            } else if (source instanceof FormModel) {
                FormModel formModel = (FormModel)source;
                if (formModel.isDirty()) {
                    this.dirtyValueAndFormModels.add(formModel);
                } else {
                    this.dirtyValueAndFormModels.remove(formModel);
                }
            } else {
                DirtyTrackingValueModel valueModel = (DirtyTrackingValueModel)source;
                if (valueModel.isDirty()) {
                    this.dirtyValueAndFormModels.add(valueModel);
                } else {
                    this.dirtyValueAndFormModels.remove(valueModel);
                }
            }
            this.dirtyUpdated();
        } else if ("committable".equals(evt.getPropertyName())) {
            this.committableUpdated();
        }
    }

    protected static class ConvertingValueModelKey {
        private final String propertyName;
        private final Class targetClass;

        public ConvertingValueModelKey(String propertyName, Class targetClass) {
            this.propertyName = propertyName;
            this.targetClass = targetClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConvertingValueModelKey)) {
                return false;
            }
            ConvertingValueModelKey key = (ConvertingValueModelKey)o;
            return this.propertyName.equals(key.propertyName) && this.targetClass == key.targetClass;
        }

        public int hashCode() {
            return this.propertyName.hashCode() * 29 + (this.targetClass == null ? 7 : this.targetClass.hashCode());
        }
    }

    protected class ChildStateChangeHandler
    implements PropertyChangeListener {
        protected ChildStateChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractFormModel.this.childStateChanged(evt);
        }
    }

    protected class ParentStateChangeHandler
    implements PropertyChangeListener {
        protected ParentStateChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractFormModel.this.parentStateChanged(evt);
        }
    }
}

