/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.form.support;

import org.springframework.beans.PropertyAccessException;
import org.springframework.binding.form.BindingErrorMessageProvider;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.support.UserMetadata;
import org.springframework.binding.format.InvalidFormatException;
import org.springframework.binding.validation.ValidationMessage;
import org.springframework.binding.validation.support.DefaultValidationMessage;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.core.Severity;

public class DefaultBindingErrorMessageProvider
implements BindingErrorMessageProvider {
    private MessageSourceAccessor messageSourceAccessor = null;

    public void setMessageSourceAccessor(MessageSourceAccessor messageSourceAccessor) {
        this.messageSourceAccessor = messageSourceAccessor;
    }

    protected MessageSourceAccessor getMessageSourceAccessor() {
        if (this.messageSourceAccessor == null) {
            this.messageSourceAccessor = (MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class);
        }
        return this.messageSourceAccessor;
    }

    public ValidationMessage getErrorMessage(FormModel formModel, String propertyName, Object valueBeingSet, Exception e) {
        String messageCode = this.getMessageCodeForException(e);
        Object[] args = new Object[]{formModel.getFieldFace(propertyName).getDisplayName(), UserMetadata.isFieldProtected(formModel, propertyName) ? "***" : valueBeingSet};
        String message = this.getMessageSourceAccessor().getMessage(messageCode, args, messageCode);
        return new DefaultValidationMessage(propertyName, Severity.ERROR, message);
    }

    protected String getMessageCodeForException(Exception e) {
        if (e instanceof PropertyAccessException) {
            return ((PropertyAccessException)((Object)e)).getErrorCode();
        }
        if (e instanceof NullPointerException) {
            return "required";
        }
        if (e instanceof InvalidFormatException) {
            return "typeMismatch";
        }
        if (e instanceof IllegalArgumentException) {
            return "typeMismatch";
        }
        if (e.getCause() instanceof Exception) {
            return this.getMessageCodeForException((Exception)e.getCause());
        }
        return "unknown";
    }
}

