/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.form.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.PropertyAccessException;
import org.springframework.binding.MutablePropertyAccessStrategy;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.form.BindingErrorMessageProvider;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.HierarchicalFormModel;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.binding.form.support.AbstractFormModel;
import org.springframework.binding.form.support.DefaultBindingErrorMessageProvider;
import org.springframework.binding.form.support.UserMetadata;
import org.springframework.binding.validation.RichValidator;
import org.springframework.binding.validation.ValidationMessage;
import org.springframework.binding.validation.ValidationResultsModel;
import org.springframework.binding.validation.Validator;
import org.springframework.binding.validation.support.DefaultValidationResults;
import org.springframework.binding.validation.support.DefaultValidationResultsModel;
import org.springframework.binding.validation.support.RulesValidator;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractValueModelWrapper;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.util.Assert;

public class DefaultFormModel
extends AbstractFormModel
implements ValidatingFormModel {
    private final DefaultValidationResultsModel validationResultsModel = new DefaultValidationResultsModel();
    private final DefaultValidationResults additionalValidationResults = new DefaultValidationResults();
    private final Map bindingErrorMessages = new HashMap();
    private boolean validating = true;
    private boolean oldValidating = true;
    private boolean oldHasErrors = false;
    private Validator validator;
    private BindingErrorMessageProvider bindingErrorMessageProvider = new DefaultBindingErrorMessageProvider();

    public DefaultFormModel() {
        this.init();
    }

    public DefaultFormModel(Object domainObject) {
        super(domainObject);
        this.init();
    }

    public DefaultFormModel(Object domainObject, boolean buffered) {
        super(domainObject, buffered);
        this.init();
    }

    public DefaultFormModel(ValueModel domainObjectHolder) {
        super(domainObjectHolder, true);
        this.init();
    }

    public DefaultFormModel(ValueModel domainObjectHolder, boolean buffered) {
        super(domainObjectHolder, buffered);
        this.init();
    }

    public DefaultFormModel(MutablePropertyAccessStrategy domainObjectAccessStrategy) {
        super(domainObjectAccessStrategy, true);
        this.init();
    }

    public DefaultFormModel(MutablePropertyAccessStrategy domainObjectAccessStrategy, boolean bufferChanges) {
        super(domainObjectAccessStrategy, bufferChanges);
        this.init();
    }

    protected void init() {
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DefaultFormModel.this.validatingUpdated();
            }
        });
        this.validationResultsModel.addPropertyChangeListener("hasErrors", this.childStateChangeHandler);
    }

    public boolean isValidating() {
        if (this.validating && this.isEnabled()) {
            if (this.getParent() instanceof ValidatingFormModel) {
                return ((ValidatingFormModel)this.getParent()).isValidating();
            }
            return true;
        }
        return false;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
        this.validatingUpdated();
    }

    protected void validatingUpdated() {
        boolean validating = this.isValidating();
        if (this.hasChanged(this.oldValidating, validating)) {
            if (validating) {
                this.validate();
            } else {
                this.validationResultsModel.clearAllValidationResults();
            }
            this.oldValidating = validating;
            this.firePropertyChange("validating", !validating, validating);
        }
    }

    public void addChild(HierarchicalFormModel child) {
        if (child.getParent() == this) {
            return;
        }
        super.addChild(child);
        if (child instanceof ValidatingFormModel) {
            this.getValidationResults().add(((ValidatingFormModel)child).getValidationResults());
            child.addPropertyChangeListener("hasErrors", this.childStateChangeHandler);
        }
    }

    public void removeChild(HierarchicalFormModel child) {
        if (child instanceof ValidatingFormModel) {
            this.getValidationResults().remove(((ValidatingFormModel)child).getValidationResults());
            child.removePropertyChangeListener("hasErrors", this.childStateChangeHandler);
        }
        super.removeChild(child);
    }

    protected void childStateChanged(PropertyChangeEvent evt) {
        super.childStateChanged(evt);
        if ("hasErrors".equals(evt.getPropertyName())) {
            this.hasErrorsUpdated();
        }
    }

    public void setParent(HierarchicalFormModel parent) {
        super.setParent(parent);
        if (parent instanceof ValidatingFormModel) {
            parent.addPropertyChangeListener("validating", this.parentStateChangeHandler);
        }
    }

    protected void parentStateChanged(PropertyChangeEvent evt) {
        super.parentStateChanged(evt);
        if ("validating".equals(evt.getPropertyName())) {
            this.validatingUpdated();
        }
    }

    public void removeParent() {
        if (this.getParent() instanceof ValidatingFormModel) {
            this.getParent().removePropertyChangeListener("validating", this.parentStateChangeHandler);
        }
        super.removeParent();
    }

    public ValidationResultsModel getValidationResults() {
        return this.validationResultsModel;
    }

    public boolean getHasErrors() {
        return this.validationResultsModel.getHasErrors();
    }

    protected void hasErrorsUpdated() {
        boolean hasErrors = this.getHasErrors();
        if (this.hasChanged(this.oldHasErrors, hasErrors)) {
            this.oldHasErrors = hasErrors;
            this.firePropertyChange("hasErrors", !hasErrors, hasErrors);
            this.committableUpdated();
        }
    }

    public void validate() {
        if (this.isValidating()) {
            this.validateAfterPropertyChanged(null);
        }
    }

    public Validator getValidator() {
        if (this.validator == null) {
            this.setValidator((Validator)new RulesValidator((FormModel)this));
        }
        return this.validator;
    }

    public void setValidator(Validator validator) {
        Assert.required((Object)validator, (String)"validator");
        this.validator = validator;
        this.validate();
    }

    public boolean isCommittable() {
        boolean superIsCommittable = super.isCommittable();
        boolean hasNoErrors = !this.getValidationResults().getHasErrors();
        return superIsCommittable && hasNoErrors;
    }

    protected ValueModel preProcessNewValueModel(String formProperty, ValueModel formValueModel) {
        if (!(formValueModel instanceof ValidatingFormValueModel)) {
            return new ValidatingFormValueModel(formProperty, formValueModel, true);
        }
        return formValueModel;
    }

    protected void postProcessNewValueModel(String formProperty, ValueModel valueModel) {
        this.validateAfterPropertyChanged(formProperty);
    }

    protected ValueModel preProcessNewConvertingValueModel(String formProperty, Class targetClass, ValueModel formValueModel) {
        return new ValidatingFormValueModel(formProperty, formValueModel, false);
    }

    protected void postProcessNewConvertingValueModel(String formProperty, Class targetClass, ValueModel valueModel) {
    }

    protected void formPropertyValueChanged(String formProperty) {
        this.validateAfterPropertyChanged(formProperty);
    }

    protected void validateAfterPropertyChanged(String formProperty) {
        Validator validator;
        if (this.isValidating() && (validator = this.getValidator()) != null) {
            DefaultValidationResults validationResults = new DefaultValidationResults(this.bindingErrorMessages.values());
            if (formProperty != null && validator instanceof RichValidator) {
                validationResults.addAllMessages(((RichValidator)validator).validate(this.getFormObject(), formProperty));
            } else {
                validationResults.addAllMessages(validator.validate(this.getFormObject()));
            }
            validationResults.addAllMessages(this.additionalValidationResults);
            this.validationResultsModel.updateValidationResults(validationResults);
        }
    }

    protected void raiseBindingError(ValidatingFormValueModel valueModel, Object valueBeingSet, Exception e) {
        ValidationMessage oldValidationMessage = (ValidationMessage)this.bindingErrorMessages.get((Object)valueModel);
        ValidationMessage newValidationMessage = this.getBindingErrorMessage(valueModel.getFormProperty(), valueBeingSet, e);
        this.bindingErrorMessages.put(valueModel, newValidationMessage);
        if (this.isValidating()) {
            this.validationResultsModel.replaceMessage(oldValidationMessage, newValidationMessage);
        }
    }

    protected void clearBindingError(ValidatingFormValueModel valueModel) {
        ValidationMessage validationMessage = (ValidationMessage)this.bindingErrorMessages.remove((Object)valueModel);
        if (validationMessage != null) {
            this.validationResultsModel.removeMessage(validationMessage);
        }
    }

    public void raiseValidationMessage(ValidationMessage validationMessage) {
        this.additionalValidationResults.addMessage(validationMessage);
        if (this.isValidating()) {
            this.validationResultsModel.addMessage(validationMessage);
        }
    }

    public void clearValidationMessage(ValidationMessage validationMessage) {
        this.additionalValidationResults.removeMessage(validationMessage);
        if (this.isValidating()) {
            this.validationResultsModel.removeMessage(validationMessage);
        }
    }

    protected ValidationMessage getBindingErrorMessage(String propertyName, Object valueBeingSet, Exception e) {
        return this.bindingErrorMessageProvider.getErrorMessage((FormModel)this, propertyName, valueBeingSet, e);
    }

    public void setBindingErrorMessageProvider(BindingErrorMessageProvider bindingErrorMessageProvider) {
        Assert.required((Object)bindingErrorMessageProvider, (String)"bindingErrorMessageProvider");
        this.bindingErrorMessageProvider = bindingErrorMessageProvider;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("buffered", this.isBuffered()).append("enabled", this.isEnabled()).append("dirty", this.isDirty()).append("validating", this.isValidating()).append("validationResults", (Object)this.getValidationResults()).toString();
    }

    protected class ValidatingFormValueModel
    extends AbstractValueModelWrapper {
        private final String formProperty;
        private final ValueChangeHandler valueChangeHander;

        public ValidatingFormValueModel(String formProperty, ValueModel model, boolean validateOnChange) {
            super(model);
            this.formProperty = formProperty;
            if (validateOnChange) {
                this.valueChangeHander = new ValueChangeHandler();
                this.addValueChangeListener(this.valueChangeHander);
            } else {
                this.valueChangeHander = null;
            }
        }

        public String getFormProperty() {
            return this.formProperty;
        }

        public void setValueSilently(Object value, PropertyChangeListener listenerToSkip) {
            try {
                if (DefaultFormModel.this.logger.isDebugEnabled()) {
                    Class<?> valueClass = value != null ? value.getClass() : null;
                    DefaultFormModel.this.logger.debug((Object)("Setting '" + this.formProperty + "' value to convert/validate '" + (UserMetadata.isFieldProtected((FormModel)DefaultFormModel.this, this.formProperty) ? "***" : value) + "', class=" + valueClass));
                }
                super.setValueSilently(value, listenerToSkip);
                DefaultFormModel.this.clearBindingError(this);
            }
            catch (ConversionException ce) {
                DefaultFormModel.this.logger.warn((Object)"Conversion exception occurred setting value", (Throwable)ce);
                DefaultFormModel.this.raiseBindingError(this, value, (Exception)((Object)ce));
            }
            catch (PropertyAccessException pae) {
                DefaultFormModel.this.logger.warn((Object)"Type Mismatch Exception occurred setting value", (Throwable)pae);
                DefaultFormModel.this.raiseBindingError(this, value, (Exception)((Object)pae));
            }
        }

        public class ValueChangeHandler
        implements PropertyChangeListener {
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultFormModel.this.formPropertyValueChanged(ValidatingFormValueModel.this.formProperty);
            }
        }
    }
}

