/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.form.support;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.binding.PropertyAccessStrategy;
import org.springframework.binding.PropertyMetadataAccessStrategy;
import org.springframework.binding.form.FormModel;

public class FormModelPropertyAccessStrategy
implements PropertyAccessStrategy {
    private final FormModel formModel;

    public FormModelPropertyAccessStrategy(FormModel formModel) {
        this.formModel = formModel;
    }

    public Object getPropertyValue(String propertyPath) throws BeansException {
        return this.formModel.getValueModel(propertyPath).getValue();
    }

    public PropertyMetadataAccessStrategy getMetadataAccessStrategy() {
        return new FormModelPropertyMetadataAccessStrategy();
    }

    public Object getDomainObject() {
        return this.formModel.getFormObject();
    }

    private class FormModelPropertyMetadataAccessStrategy
    implements PropertyMetadataAccessStrategy {
        private FormModelPropertyMetadataAccessStrategy() {
        }

        public boolean isReadable(String propertyName) {
            return true;
        }

        public boolean isWriteable(String propertyName) {
            return !FormModelPropertyAccessStrategy.this.formModel.getFieldMetadata(propertyName).isReadOnly();
        }

        public Class getPropertyType(String propertyName) {
            return FormModelPropertyAccessStrategy.this.formModel.getFieldMetadata(propertyName).getPropertyType();
        }

        public Object getUserMetadata(String propertyName, String key) {
            return FormModelPropertyAccessStrategy.this.formModel.getFieldMetadata(propertyName).getUserMetadata(key);
        }

        public Map getAllUserMetadata(String propertyName) {
            return FormModelPropertyAccessStrategy.this.formModel.getFieldMetadata(propertyName).getAllUserMetadata();
        }
    }
}

