/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.validation.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.binding.validation.ValidationMessage;
import org.springframework.binding.validation.ValidationResults;
import org.springframework.binding.validation.support.DefaultValidationMessage;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.core.Severity;
import org.springframework.util.CachingMapDecorator;
import org.springframework.util.ObjectUtils;

public class DefaultValidationResults
implements ValidationResults {
    private final Set messages = new HashSet();
    private CachingMapDecorator messagesSubSets = new CachingMapDecorator(){

        protected Object create(Object key) {
            HashSet<ValidationMessage> messagesSubSet = new HashSet<ValidationMessage>();
            Iterator i = DefaultValidationResults.this.messages.iterator();
            while (i.hasNext()) {
                ValidationMessage message = (ValidationMessage)i.next();
                if (key instanceof Severity && message.getSeverity().equals(key)) {
                    messagesSubSet.add(message);
                    continue;
                }
                if (!ObjectUtils.nullSafeEquals((Object)message.getProperty(), (Object)key)) continue;
                messagesSubSet.add(message);
            }
            return Collections.unmodifiableSet(messagesSubSet);
        }
    };

    public DefaultValidationResults() {
    }

    public DefaultValidationResults(ValidationResults validationResults) {
        this.addAllMessages(validationResults);
    }

    public DefaultValidationResults(Collection validationMessages) {
        this.addAllMessages(validationMessages);
    }

    public void addAllMessages(ValidationResults validationResults) {
        this.addAllMessages(validationResults.getMessages());
    }

    public void addAllMessages(Collection validationMessages) {
        if (this.messages.addAll(validationMessages)) {
            this.messagesSubSets.clear();
        }
    }

    public void addMessage(ValidationMessage validationMessage) {
        if (this.messages.add(validationMessage)) {
            this.messagesSubSets.clear();
        }
    }

    public void addMessage(String field, Severity severity, String message) {
        this.addMessage(new DefaultValidationMessage(field, severity, message));
    }

    public void removeMessage(ValidationMessage message) {
        this.messages.remove(message);
        this.messagesSubSets.clear();
    }

    public boolean getHasErrors() {
        return this.getMessageCount(Severity.ERROR) > 0;
    }

    public boolean getHasWarnings() {
        return this.getMessageCount(Severity.WARNING) > 0;
    }

    public boolean getHasInfo() {
        return this.getMessageCount(Severity.INFO) > 0;
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public int getMessageCount(Severity severity) {
        return this.getMessages(severity).size();
    }

    public int getMessageCount(String fieldName) {
        return this.getMessages(fieldName).size();
    }

    public Set getMessages() {
        return Collections.unmodifiableSet(this.messages);
    }

    public Set getMessages(Severity severity) {
        return (Set)this.messagesSubSets.get((Object)severity);
    }

    public Set getMessages(String fieldName) {
        return (Set)this.messagesSubSets.get((Object)fieldName);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("messages", (Object)this.getMessages()).toString();
    }

    public void clearMessages() {
        this.messages.clear();
        this.messagesSubSets.clear();
    }

    public void clearMessages(String fieldName) {
        Set messagesForFieldName = this.getMessages(fieldName);
        Iterator mi = messagesForFieldName.iterator();
        while (mi.hasNext()) {
            this.messages.remove(mi.next());
        }
        this.messagesSubSets.clear();
    }
}

