/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.swing;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractValueModelAdapter;
import org.springframework.util.Assert;

public class AsYouTypeTextComponentAdapter
extends AbstractValueModelAdapter
implements DocumentListener {
    private final JTextComponent control;
    private boolean settingText;

    public AsYouTypeTextComponentAdapter(JTextComponent control, ValueModel valueModel) {
        super(valueModel);
        Assert.notNull((Object)control);
        this.control = control;
        this.control.getDocument().addDocumentListener(this);
        this.initalizeAdaptedValue();
    }

    public void removeUpdate(DocumentEvent e) {
        this.controlTextValueChanged();
    }

    public void insertUpdate(DocumentEvent e) {
        this.controlTextValueChanged();
    }

    public void changedUpdate(DocumentEvent e) {
        this.controlTextValueChanged();
    }

    private void controlTextValueChanged() {
        if (!this.settingText) {
            this.adaptedValueChanged(this.control.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void valueModelValueChanged(Object value) {
        try {
            this.settingText = true;
            this.control.setText((String)value);
        }
        finally {
            this.settingText = false;
        }
    }
}

