/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.config;

import java.awt.Image;
import java.util.Locale;
import javax.swing.Icon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.config.ApplicationObjectConfigurer;
import org.springframework.richclient.command.config.CommandButtonIconInfo;
import org.springframework.richclient.command.config.CommandButtonLabelInfo;
import org.springframework.richclient.command.config.CommandIconConfigurable;
import org.springframework.richclient.command.config.CommandLabelConfigurable;
import org.springframework.richclient.core.DescriptionConfigurable;
import org.springframework.richclient.core.LabelConfigurable;
import org.springframework.richclient.core.LabelInfo;
import org.springframework.richclient.core.SecurityControllable;
import org.springframework.richclient.core.TitleConfigurable;
import org.springframework.richclient.image.IconSource;
import org.springframework.richclient.image.ImageSource;
import org.springframework.richclient.image.NoSuchImageResourceException;
import org.springframework.richclient.image.config.IconConfigurable;
import org.springframework.richclient.image.config.ImageConfigurable;
import org.springframework.richclient.security.SecurityController;
import org.springframework.richclient.security.SecurityControllerManager;
import org.springframework.richclient.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultApplicationObjectConfigurer
implements ApplicationObjectConfigurer,
BeanPostProcessor {
    public static final String PRESSED_ICON_KEY = "pressedIcon";
    public static final String DISABLED_ICON_KEY = "disabledIcon";
    public static final String ROLLOVER_ICON_KEY = "rolloverIcon";
    public static final String SELECTED_ICON_KEY = "selectedIcon";
    public static final String ICON_KEY = "icon";
    public static final String IMAGE_KEY = "image";
    public static final String DESCRIPTION_KEY = "description";
    public static final String CAPTION_KEY = "caption";
    public static final String TITLE_KEY = "title";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean loadOptionalIcons = true;
    private MessageSource messageSource;
    private ImageSource imageSource;
    private IconSource iconSource;
    private SecurityControllerManager securityControllerManager;

    public DefaultApplicationObjectConfigurer() {
    }

    public DefaultApplicationObjectConfigurer(MessageSource messageSource) {
        this(messageSource, null, null, null);
    }

    public DefaultApplicationObjectConfigurer(MessageSource messageSource, ImageSource imageSource) {
        this(messageSource, imageSource, null, null);
    }

    public DefaultApplicationObjectConfigurer(MessageSource messageSource, ImageSource imageSource, IconSource iconSource, SecurityControllerManager securityControllerManager) {
        this.messageSource = messageSource;
        this.imageSource = imageSource;
        this.iconSource = iconSource;
        this.securityControllerManager = securityControllerManager;
    }

    public void setLoadOptionalIcons(boolean loadOptionalIcons) {
        this.loadOptionalIcons = loadOptionalIcons;
    }

    protected MessageSource getMessageSource() {
        if (this.messageSource == null) {
            this.messageSource = (MessageSource)ApplicationServicesLocator.services().getService(MessageSource.class);
        }
        return this.messageSource;
    }

    protected IconSource getIconSource() {
        if (this.iconSource == null) {
            this.iconSource = (IconSource)ApplicationServicesLocator.services().getService(IconSource.class);
        }
        return this.iconSource;
    }

    protected ImageSource getImageSource() {
        if (this.imageSource == null) {
            this.imageSource = (ImageSource)ApplicationServicesLocator.services().getService(ImageSource.class);
        }
        return this.imageSource;
    }

    protected SecurityControllerManager getSecurityControllerManager() {
        if (this.securityControllerManager == null) {
            this.securityControllerManager = (SecurityControllerManager)ApplicationServicesLocator.services().getService(SecurityControllerManager.class);
        }
        return this.securityControllerManager;
    }

    public void configure(Object object, String objectName) {
        if (object == null) {
            this.logger.debug((Object)"object to be configured is null");
            return;
        }
        Assert.required((Object)objectName, (String)"objectName");
        if (object instanceof TitleConfigurable) {
            this.configureTitle((TitleConfigurable)object, objectName);
        }
        if (object instanceof LabelConfigurable) {
            this.configureLabel((LabelConfigurable)object, objectName);
        }
        if (object instanceof CommandLabelConfigurable) {
            this.configureCommandLabel((CommandLabelConfigurable)object, objectName);
        }
        if (object instanceof DescriptionConfigurable) {
            this.configureDescription((DescriptionConfigurable)object, objectName);
        }
        if (object instanceof ImageConfigurable) {
            this.configureImage((ImageConfigurable)object, objectName);
        }
        if (object instanceof IconConfigurable) {
            this.configureIcon((IconConfigurable)object, objectName);
        }
        if (object instanceof CommandIconConfigurable) {
            this.configureCommandIcons((CommandIconConfigurable)object, objectName);
        }
        if (object instanceof SecurityControllable) {
            this.configureSecurityController((SecurityControllable)object, objectName);
        }
    }

    protected void configureTitle(TitleConfigurable configurable, String objectName) {
        Assert.required((Object)configurable, (String)"configurable");
        Assert.required((Object)objectName, (String)"objectName");
        String title = this.loadMessage(objectName + "." + TITLE_KEY);
        if (StringUtils.hasText((String)title)) {
            configurable.setTitle(title);
        }
    }

    protected void configureLabel(LabelConfigurable configurable, String objectName) {
        Assert.required((Object)configurable, (String)"configurable");
        Assert.required((Object)objectName, (String)"objectName");
        String labelStr = this.loadMessage(objectName + ".label");
        if (StringUtils.hasText((String)labelStr)) {
            LabelInfo labelInfo = LabelInfo.valueOf((String)labelStr);
            configurable.setLabelInfo(labelInfo);
        }
    }

    protected void configureCommandLabel(CommandLabelConfigurable configurable, String objectName) {
        Assert.required((Object)configurable, (String)"configurable");
        Assert.required((Object)objectName, (String)"objectName");
        String labelStr = this.loadMessage(objectName + ".label");
        if (StringUtils.hasText((String)labelStr)) {
            CommandButtonLabelInfo labelInfo = CommandButtonLabelInfo.valueOf(labelStr);
            configurable.setLabelInfo(labelInfo);
        }
    }

    protected void configureDescription(DescriptionConfigurable configurable, String objectName) {
        String description;
        Assert.required((Object)configurable, (String)"configurable");
        Assert.required((Object)objectName, (String)"objectName");
        String caption = this.loadMessage(objectName + "." + CAPTION_KEY);
        if (StringUtils.hasText((String)caption)) {
            configurable.setCaption(caption);
        }
        if (StringUtils.hasText((String)(description = this.loadMessage(objectName + "." + DESCRIPTION_KEY)))) {
            configurable.setDescription(description);
        }
    }

    protected void configureImage(ImageConfigurable configurable, String objectName) {
        Assert.required((Object)configurable, (String)"configurable");
        Assert.required((Object)objectName, (String)"objectName");
        Image image = this.loadImage(objectName, IMAGE_KEY);
        if (image != null) {
            configurable.setImage(image);
        }
    }

    protected void configureIcon(IconConfigurable configurable, String objectName) {
        Assert.required((Object)configurable, (String)"configurable");
        Assert.required((Object)objectName, (String)"objectName");
        Icon icon = this.loadIcon(objectName, ICON_KEY);
        if (icon != null) {
            configurable.setIcon(icon);
        }
    }

    protected void configureCommandIcons(CommandIconConfigurable configurable, String objectName) {
        Assert.required((Object)configurable, (String)"configurable");
        Assert.required((Object)objectName, (String)"objectName");
        this.setIconInfo(configurable, objectName, false);
        this.setIconInfo(configurable, objectName, true);
    }

    protected void configureSecurityController(SecurityControllable controllable, String objectName) {
        Assert.required((Object)controllable, (String)"controllable");
        Assert.required((Object)objectName, (String)"objectName");
        String controllerId = controllable.getSecurityControllerId();
        if (controllerId != null) {
            SecurityController controller;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Lookup SecurityController with id [" + controllerId + "]"));
            }
            if ((controller = this.getSecurityControllerManager().getSecurityController(controllerId)) != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("configuring SecurityControllable [" + objectName + "]; security controller id='" + controllerId + "'"));
                }
                controller.addControlledObject(controllable);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("configuring SecurityControllable [" + objectName + "]; no security controller for id='" + controllerId + "'"));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("configuring SecurityControllable [" + objectName + "]; no security controller Id specified"));
        }
    }

    protected void setIconInfo(CommandIconConfigurable object, String objectName, boolean large) {
        CommandButtonIconInfo iconInfo;
        Assert.required((Object)object, (String)"object");
        Assert.required((Object)objectName, (String)"objectName");
        Icon icon = this.loadIcon(objectName, ICON_KEY, large);
        if (icon == null) {
            return;
        }
        if (this.loadOptionalIcons) {
            Icon selectedIcon = this.loadIcon(objectName, SELECTED_ICON_KEY, large);
            Icon rolloverIcon = this.loadIcon(objectName, ROLLOVER_ICON_KEY, large);
            Icon disabledIcon = this.loadIcon(objectName, DISABLED_ICON_KEY, large);
            Icon pressedIcon = this.loadIcon(objectName, PRESSED_ICON_KEY, large);
            iconInfo = new CommandButtonIconInfo(icon, selectedIcon, rolloverIcon, disabledIcon, pressedIcon);
        } else {
            iconInfo = new CommandButtonIconInfo(icon);
        }
        if (large) {
            object.setLargeIconInfo(iconInfo);
        } else {
            object.setIconInfo(iconInfo);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.configure(bean, beanName);
        return bean;
    }

    private String loadMessage(String messageCode) {
        Assert.required((Object)messageCode, (String)"messageCode");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving label with code '" + messageCode + "'"));
        }
        try {
            return this.getMessageSource().getMessage(messageCode, null, this.getLocale());
        }
        catch (NoSuchMessageException e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("The message source is unable to find message code [" + messageCode + "]. Ignoring and returning null."));
            }
            return null;
        }
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    private Icon loadIcon(String objectName, String iconType) {
        return this.loadIcon(objectName, iconType, false);
    }

    private Icon loadIcon(String objectName, String iconType, boolean large) {
        String key = objectName + (large ? ".large." : ".") + iconType;
        return this.getIconSource().getIcon(key);
    }

    private Image loadImage(String objectName, String imageType) {
        String key = objectName + "." + imageType;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resolving optional image with code '" + key + "'"));
            }
            return this.getImageSource().getImage(key);
        }
        catch (NoSuchImageResourceException e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Labelable object's image '" + key + "' does not exist in image bundle; continuing..."));
            }
            return null;
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

